<?php 

namespace App\Controllers;
use App\Models\cargosautoridadModels;
use App\Models\detalle_roles_permisosModels;

class Cautoridad extends BaseController{
	
	protected $cautoridad;
	protected $reglas,$session,$detalleRolesPermisos;
	
	public function __construct(){
		
		$this->cautoridad=new CargosautoridadModels();
        $this->session=session();
        $this->detalleRolesPermisos=new detalle_roles_permisosModels();
	helper(['form']);
		$this->reglas=[
			'nombre'=>[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.'
					   ]
			]
			
			];
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
public function index($activo=1){
        

if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
    
    $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'SubCategorias');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/inicio');
           
           
            
        }
		$cargos=$this->cautoridad->where('activo',$activo)->findAll();
		$data=['titulo'=>'Cargos de Autoridades','datos'=>$cargos];
		
		
        echo view('header');
		echo view('cautoridad/cautoridad', $data);
		echo view('footer');
		
	}
	
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
public function agregar(){
        

if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }

     $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'CategoriasAgregar');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/cautoridad');
           
           
            
        }
    
    
    
    
		
		
		$data=['titulo'=>'Agregar nuevo cargo de Autoridad'];
		
		
        echo view('header');
		echo view('cautoridad/agregar', $data);
		echo view('footer');
		
	}

//--------------------------------------------------------------------------------------------------------------------------------------------------------------

	public function insertar(){
		

if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		if($this->request->getMethod()=="post" && $this->validate($this->reglas)){
		$this->cautoridad->save(['cargo'=> $this->request->getPost('nombre')]);
		return redirect()->to(base_url().'/cautoridad');
		
		}else{
			
			$data=['titulo'=>'Agregar nuevo cargo de Autoridad', 'validation'=> $this->validator];
		
		
        echo view('header');
		echo view('cautoridad/agregar', $data);
		echo view('footer');
		
			
		}
        
		
	}
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	
	public function editar($id, $valid=null){
        

if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'CategoriasEditar');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/juicios');
           
           
            
        }
		
		$unidad=$this->cautoridad->where('id',$id)->first();
		
		if($valid != null){
		$data=['titulo'=>'Editar Cargo de Autoridad', 'datos'=>$unidad,'validation'=> $valid];
		}else{
			$data=['titulo'=>'Editar Cargo de Autoridad', 'datos'=>$unidad];
			
		}
		
        echo view('header');
		echo view('cautoridad/editar', $data);
		echo view('footer');
		
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	
	public function actualizar(){
		

if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		if($this->request->getMethod()=="post" && $this->validate($this->reglas)){
		$this->cautoridad->update($this->request->getPost('id'),[ 'cargo'=>$this->request->getPost('nombre')]);
		return redirect()->to(base_url().'/cautoridad');
		
		}else{
			
			return $this->editar($this->request->getPost('id'),$this->validator);
			
		}
        
		
	}
	
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function eliminar($id){
        

if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		
        $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'CategoriasEliminar');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/cautoridad');
           
           
            
        }
		
		$this->cautoridad->update($id,['activo'=> 0]);
		return redirect()->to(base_url().'/cautoridad');
		
		
        
		
	}
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------	
	public function eliminados($activo=0){
        

if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        
        $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'CategoriasEliminados');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/categorias');
           
           
            
        }
		$categorias=$this->cautoridad->where('activo',$activo)->findAll();
		$data=['titulo'=>'Cargos de autoridad eliminadas','datos'=>$categorias];
		
		
        echo view('header');
		echo view('cautoridad/eliminadas', $data);
		echo view('footer');
		
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	
		public function reingresar($id){
            

if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		
		
		$this->cautoridad->update($id,['activo'=> 1]);
		return redirect()->to(base_url().'/cautoridad');
		
		
        
		
	}
	
	
	
}






?>