<?php 

namespace App\Controllers;
use App\Models\AutoridadesModels;
use App\Models\cargosautoridadModels;
use App\Models\juzgadosModels;
use App\Models\EstadosModels;


use App\Models\logsModels;
use App\Models\detalle_roles_permisosModels;

class Autoridades extends BaseController{
	
	protected $autoridades;
    protected $estados;
	protected $reglas;
	protected $reglas2;
	protected $reglas3,$session,$logss,$detalleRolesPermisos;
	
	
	public function __construct(){
		
		$this->autoridades=new AutoridadesModels();
		$this->cautoridad=new CargosautoridadModels();
        
		$this->juzgados=new JuzgadosModels();
        $this->estados=new EstadosModels();
        
        
        $this->logss=new logsModels();
        $this->session=session();
        $this->detalleRolesPermisos=new detalle_roles_permisosModels();
		helper(['form']);
				
		
		$this->reglas2=[
		
			'usuario'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo Usuario es obligatorio.'
					   ]
				],			
			'pass'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'La Contraseña es obligatoria.'
					   ]
				]
			];
		
		$this->reglas3=[
		
			'pass'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.'
					   ]
				],			
			'con_pass'=>
			[
					   'rules'=>'required|matches[pass]',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.',
						   'matches'=> 'Las contraseñas no coindicen.'
					   ]
				]
				];
		
		$this->reglas4=[
		
			
			'nombre'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.'
						  
					   ]
				],
			'rol'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.'
						  
					   ]
				],
			'caja'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.'
						  
					   ]
				]
				];			
		
		
		
		
		
		
		
		
		
		
	}
    
//--------------------------------------------------------------------------------------------------------------------------------------------------------------    
	public function index($activo=1){
        
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		$permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'SubUsuarios');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/inicio');
           
           
            
        }
		
			$cautoridadd= $this->cautoridad->where('activo',1)->findAll();
        
		$juzgadoss=$this->juzgados->where('activo',1)->findAll();
        
        
		$autoridades=$this->autoridades->where('activo',$activo)->findAll();
        
        $estados=$this->estados->findAll();
        
       
        
		$data=['titulo'=>'Autoridades registrados','datos'=>$autoridades,'cargoautoridad'=>$cautoridadd,'juzgados'=>$juzgadoss, 'estadoss'=>$estados];
		
		
        echo view('header');
		echo view('autoridades/autoridades', $data);
		echo view('footer');
		
	}
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function insertar(){
        
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
    
    
    
    
        }
		
		
		
		
		if($this->request->getMethod()=="post"){
			
			$a=$_POST['telefono'];
			$b = str_replace('-', '', $a );
			$c=$_POST['telefono2'];
			$d= str_replace('-', '', $c );
						
			$this->autoridades->save(['nombre'=> $this->request->getPost('Nombre'),
								   'apellidoP'=>$this->request->getPost('ApellidoP'),
                                   'apellidoM'=>$this->request->getPost('ApellidoM'),
								   'id_estado'=>$this->request->getPost('estado'),
                                   'telefono1'=>$b,
                                   'telefono2'=>$d,
                                   'email'=>$this->request->getPost('Email'),
                                   'id_cargoautoridad'=>$this->request->getPost('Cargo'),
								   'id_juzgado'=>$this->request->getPost('Juzgado')]);
			
		return redirect()->to(base_url().'/autoridades');
			
		}
		
	
	}
	
	
    
    
    
    
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function editar($id, $valid=null){
        
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'UsuariosEditar');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/usuarios');
           
           
            
        }
		
		
			$roles = $this->roles->where('activo',1)->findAll();
		$caja=$this->cajas->where('activo',1)->findAll();
		
		$usuario = $this->usuarios->where('id',$id)->first();
		
		if($valid != null){
			$data=['titulo'=>'Editar usuario', 'usuario'=>$usuario, 'rol'=>$roles, 'cajaW'=>$caja, 'validation'=> $valid];
		}
		else {
			$data=['titulo'=>'Editar usuario', 'usuario'=>$usuario, 'rol'=>$roles, 'cajaW'=>$caja];
		}
		
		
		
        echo view('header');
		echo view('usuarios/editar', $data);
		echo view('footer');
		
	}
	
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
public function actualizar(){
        
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		
			
		if($this->request->getMethod()=="post"){
		

			$a=$_POST['telefono'];
			$b = str_replace('-', '', $a );
			$c=$_POST['telefono2'];
			$d= str_replace('-', '', $c );

		$this->autoridades->update($this->request->getPost('id'),
                                  ['nombre'=> $this->request->getPost('Nombre'),
								   'apellidoP'=>$this->request->getPost('ApellidoP'),
                                   'apellidoM'=>$this->request->getPost('ApellidoM'),
                                   
								   'id_estado'=>$this->request->getPost('estado'),
                                   
                                   'telefono1'=>$b,
                                   'telefono2'=>$d,
                                   'email'=>$this->request->getPost('Email'),
                                   'id_cargoautoridad'=>$this->request->getPost('Cargo'),
								   'id_juzgado'=>$this->request->getPost('Juzgado')]);
                              
            
         
		return redirect()->to(base_url().'/autoridades');
		
		
		}else{
			
			return $this->editar($this->request->getPost('id'),$this->validator);
			
		}
		
	}
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
public function eliminar($id){
        
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
     $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'UsuariosEliminar');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/autoridades');
           
           
            
        }
		
		
		$this->autoridades->update($id,['activo'=> 0]);
		return redirect()->to(base_url().'/autoridades');
		
		
        
		
	}
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
public function eliminados($activo=0){
		
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
    $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'UsuariosEliminados');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/autoridades');
           
           
            
        }
    
    
    
    $cautoridadd= $this->cautoridad->where('activo',1)->findAll();
        
		$juzgadoss=$this->juzgados->where('activo',1)->findAll();
        
        
		$autoridades=$this->autoridades->where('activo',$activo)->findAll();
        
        $estados=$this->estados->findAll();
        
       
        
		$data=['titulo'=>'Autoridades eliminados','datos'=>$autoridades,'cargoautoridad'=>$cautoridadd,'juzgados'=>$juzgadoss, 'estadoss'=>$estados];
		
		
        echo view('header');
		echo view('autoridades/eliminadas', $data);
		echo view('footer');
    

		
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function reingresar($id){
        
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		
		
		$this->autoridades->update($id,['activo'=> 1]);
		return redirect()->to(base_url().'/autoridades');
		
		
        
		
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function login(){
		
		echo view ('login');
		
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function valida(){
		
		if($this->request->getMethod()=="post" && $this->validate($this->reglas2)){
			
			$usuarios=$this->request->getPost('usuario');
			$contra=$this->request->getPost('pass');
			
			$consultaUsuarios= $this->usuarios->where('usuario',$usuarios)->first();
			
			if($consultaUsuarios != null){
				if(password_verify($contra, $consultaUsuarios['password'])){
					
					$datosSesion=[
						'id_id'=>$consultaUsuarios['id'],
						'id_usuario'=>$consultaUsuarios['usuario'],
						'id_nombre'=>$consultaUsuarios['nombre'],
						'id_caja'=>$consultaUsuarios['id_caja'],
						'id_rol'=>$consultaUsuarios['id_rol']
					
					];
                    
                    $ip=$_SERVER['REMOTE_ADDR'];
                    $detalles=$_SERVER['HTTP_USER_AGENT'];
                    
                    $this->logss->save([
                        'id_usuario'=>$consultaUsuarios['id'],
                        'evento'=>'Inicio de sesión',
                        'ip'=>$ip,
                        'detalles'=>$detalles,
                    ]);
					
					$session=session();
					$session->set($datosSesion);
					return redirect()->to(base_url().'/inicio');
					
					
				}else {
					
					$data['error']="&nbsp;&nbsp;La contraseña no coinciden";
					echo view('login',$data);
					
				}
				
				
			}else{
				
				
				$data['error']="&nbsp;&nbsp;El usuario no existe";
				echo view('login',$data);
			}
			
		}
		else {
			
			$data=['validation'=> $this->validator];
			
				echo view('login',$data);
				
				
		}
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function logout(){
		
		
		
	
		
		$session= session();
        
         $ip=$_SERVER['REMOTE_ADDR'];
                    $detalles=$_SERVER['HTTP_USER_AGENT'];
                    
                    $this->logss->save([
                        'id_usuario'=> $session->id_id,
                        'evento'=>'Cierre de sesión',
                        'ip'=>$ip,
                        'detalles'=>$detalles,
                    ]);
					
        
        
		$session->destroy();
		return redirect()->to(base_url());

	}
	
	
	
	

	
	
	
	
	
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function editarCont(){
        
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        
		
		$sessionN =session();
			
		$usuario=$this->usuarios->where('id',$sessionN->id_id)->first();

		$data=['titulo'=>'Cambiar contraseña','sesion'=>$usuario];
		
		
        echo view('header');
		echo view('usuarios/editarCont', $data);
		echo view('footer');
		
	}
	
	

	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function actualizarCont(){
        
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		
		
		if($this->request->getMethod()=="post" && $this->validate($this->reglas3)){
			 $sessionRT=session();
			$id=$sessionRT->id_id;
			
			$hash=password_hash($this->request->getPost('pass'),PASSWORD_DEFAULT);
			
			$this->usuarios->update($id,['password'=>$hash]);
			
		$usuario=$this->usuarios->where('id',$sessionRT->id_id)->first();

		$data=['titulo'=>'Cambiar contraseña','sesion'=>$usuario, 'mensaje'=>'Contraseña actualizada'];
		
		
        echo view('header');
		echo view('usuarios/editarCont', $data);
		echo view('footer');
		
			
		}
		
		else {
			
				$sessionN =session();
			
		$usuario=$this->usuarios->where('id',$sessionN->id_id)->first();

		$data=['titulo'=>'Cambiar contraseña','sesion'=>$usuario, 'validation'=> $this->validator];
		
		
        echo view('header');
		echo view('usuarios/editarCont', $data);
		echo view('footer');
		
			

			
			
		}
		
        
		
		
		
	}
	
	
	
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function actualizarCont2(){
        
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        
		
		
        if($this->request->getMethod()=="post" && $this->validate($this->reglas3)){
		
			
			$hash=password_hash($this->request->getPost('pass'),PASSWORD_DEFAULT);
			
		$this->usuarios->update($this->request->getPost('id'),['password'=>$hash]);
		return redirect()->to(base_url().'/usuarios');
		
		
		}else{
			
			return $this->editarCont2($this->request->getPost('id'),$this->validator);
			
		}
		
	}
	
		
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function editarCont2($id, $valid=null){
		
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'UsuariosEditarContraseña');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/usuarios');
           
           
            
        }

		$usuario = $this->usuarios->where('id',$id)->first();
		
		if($valid != null){
			$data=['titulo'=>'Editar usuario', 'usuario'=>$usuario,'validation'=> $valid];
		}
		else {
			$data=['titulo'=>'Editar usuario', 'usuario'=>$usuario ];
		}
		
		
		
        echo view('header');
		echo view('usuarios/editarCont2', $data);
		echo view('footer');
		
	}
	
	
	
	
	

}

?>