<?php 

namespace App\Controllers;
use App\Models\UsuariosModels;
use App\Models\rolesModels;
use App\Models\cajasModels;
use App\Models\logsModels;
use App\Models\detalle_roles_permisosModels;

class Usuarios extends BaseController{
	
	protected $usuarios;
	protected $reglas;
	protected $reglas2;
	protected $reglas3,$session,$logss,$detalleRolesPermisos;
	
	
	public function __construct(){
		
		$this->usuarios=new UsuariosModels();
		$this->roles=new RolesModels();
		$this->cajas=new CajasModels();
        $this->logss=new logsModels();
        $this->session=session();
        $this->detalleRolesPermisos=new detalle_roles_permisosModels();
		helper(['form']);
		$this->reglas=[
			'nombre'=>[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.'
					   ]
			],
			'usuario'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.'
					   ]
				],			
			'pass'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.'
					   ]
				],			
			'con_pass'=>
			[
					   'rules'=>'required|matches[pass]',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.',
						   'matches'=> 'Las contraseñas no coindicen.'
					   ]
				],
			'rol'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.'
					   ]
				]
			];
		
		
		
		$this->reglas2=[
		
			'usuario'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo Usuario es obligatorio.'
					   ]
				],			
			'pass'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'La Contraseña es obligatoria.'
					   ]
				]
			];
		
		$this->reglas3=[
		
			'pass'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.'
					   ]
				],			
			'con_pass'=>
			[
					   'rules'=>'required|matches[pass]',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.',
						   'matches'=> 'Las contraseñas no coindicen.'
					   ]
				]
				];
		
		$this->reglas4=[
		
			
			'nombre'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.'
						  
					   ]
				],
			'rol'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.'
						  
					   ]
				]
			
				];			
		
		
		
		
		
		
		
		
		
		
	}
    
//--------------------------------------------------------------------------------------------------------------------------------------------------------------    
	public function index($activo=1){
        
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		$permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'SubUsuarios');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/inicio');
           
           
            
        }
		
			$ro = $this->roles->where('activo',1)->findAll();
		$ca=$this->cajas->where('activo',1)->findAll();
		$usuarios=$this->usuarios->where('activo',$activo)->findAll();
		$data=['titulo'=>'Litigantes','datos'=>$usuarios,'roles'=>$ro, 'cajas'=>$ca];
		
		
        echo view('header');
		echo view('usuarios/usuarios', $data);
		echo view('footer');
		
	}
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function agregar(){
        
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'UsuariosAgregar');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/usuarios');
           
           
            
        }
		
		
		
		$rol= $this->roles->where('activo',1)->findAll();
		$caja=$this->cajas->where('activo',1)->findAll();

		$data=['titulo'=>'Agregar usuario','rolines'=>$rol,'cajines'=>$caja ];
		
		
        echo view('header');
		echo view('usuarios/agregar', $data);
		echo view('footer');
		
	}
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function insertar(){
        
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		
		
		
		
		if($this->request->getMethod()=="post"){
			
			
			$hash=password_hash($this->request->getPost('pass'),PASSWORD_DEFAULT);

		
			$folioUsuario=$_POST['folioUsuario'];

			$a=$_POST['celular'];
			$b = str_replace('-', '', $a );

		
			
			
			$doc5=$this->request->getFile('fotoreciente');

			

			
							if ($doc5 != ""){

								$doc5=$this->request->getFile('fotoreciente');
								
								
									//borrar archivo en caso de que ya exista 
									$rutaDoc5 = "./dist/img/usuarios/$folioUsuario-fotoreciente.png";
									
								
									if (file_exists($rutaDoc5)){
								
										unlink($rutaDoc5);
										$carpeta="./dist/img/usuarios";
										if (!file_exists($carpeta)){
								
											mkdir($carpeta,077,true);
										}
								
									}
									
																
								
								
								$doc5->move("./dist/img/usuarios", "$folioUsuario-fotoreciente.png");
								
								
								
								$nomDoc5="$folioUsuario-fotoreciente.png";
								$extension="png";
								
								
											//----------------------------------------------insertamos 
								
								}




			$this->usuarios->save(['usuario'=> $this->request->getPost('usuario'),
			
			'nombre'=>$this->request->getPost('nombre'),
			'apellidos'=>$this->request->getPost('Apellidos'),
			'puesto'=>$this->request->getPost('Puesto'),
			'correo'=>$this->request->getPost('Correo'),
			'nomFotoReciente'=>$nomDoc5,

			'fotoCliente_ext'=>$extension,

			

			'nCel'=>$b,
		    'password'=>$hash,
			
				   
			'id_rol'=>$this->request->getPost('Privilegios')]);




			
															  
															   														   
															  
															   


															  

															   

															   
												


















			
		return redirect()->to(base_url().'/usuarios');
			
		}
		
		else {
			
			$rol= $this->roles->where('activo',1)->findAll();
		$caja=$this->cajas->where('activo',1)->findAll();
        $data=['titulo'=>'Agregar usuario','rolines'=>$rol,'cajines'=>$caja, 'validation'=> $this->validator];
		
		
        echo view('header');
		echo view('usuarios/agregar', $data);
		echo view('footer');
			
		}
		
        
		
	}
	
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function editar($id, $valid=null){
        
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'UsuariosEditar');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/usuarios');
           
           
            
        }
		
		
			$roles = $this->roles->where('activo',1)->findAll();
		$caja=$this->cajas->where('activo',1)->findAll();
		
		$usuario = $this->usuarios->where('id',$id)->first();
		
		if($valid != null){
			$data=['titulo'=>'Editar usuario', 'usuario'=>$usuario, 'rol'=>$roles, 'cajaW'=>$caja, 'validation'=> $valid];
		}
		else {
			$data=['titulo'=>'Editar usuario', 'usuario'=>$usuario, 'rol'=>$roles, 'cajaW'=>$caja];
		}
		
		
		
        echo view('header');
		echo view('usuarios/editar', $data);
		echo view('footer');
		
	}
	
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
public function actualizar(){
        
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		
			
		if($this->request->getMethod()=="post" && $this->validate($this->reglas4)){
		
		$this->usuarios->update($this->request->getPost('id'),['nombre'=>$this->request->getPost('nombre'),'id_caja'=>$this->request->getPost('caja'),'id_rol'=>$this->request->getPost('rol')]);
		return redirect()->to(base_url().'/usuarios');
		
		
		}else{
			
			return $this->editar($this->request->getPost('id'),$this->validator);
			
		}
		
	}
	


//--------------------------------------------------------------------------------------------------------------------------------------------------------------
public function editarPerfil($id, $valid=null){
        
	if (!isset($this->session->id_usuario)){
				return redirect()->to(base_url());
			}
			$permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'UsuariosEditar');
			
			if(!$permiso){
				
				
				
				
				return redirect()->to(base_url().'/usuarios');
			   
			   
				
			}
			
			
				$roles = $this->roles->where('activo',1)->findAll();
			$caja=$this->cajas->where('activo',1)->findAll();
			
			$usuario = $this->usuarios->where('id',$id)->first();
			
			if($valid != null){
				$data=['titulo'=>'Editar litigante', 'usuario'=>$usuario, 'rol'=>$roles, 'cajaW'=>$caja, 'validation'=> $valid];
			}
			else {
				$data=['titulo'=>'Editar usuario', 'usuario'=>$usuario, 'rol'=>$roles, 'cajaW'=>$caja];
			}
			
			
			
			echo view('header');
			echo view('usuarios/editarPerfil', $data);
			echo view('footer');
			
		}
		
		
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function actualizarPerfil(){
			
		if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
     $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'UsuariosEliminar');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/usuarios');
           
           
            
        }
		$folioLitigante=$_POST['folioLitigante'];

		$a=$_POST['nCelular'];
		$b = str_replace('-', '', $a );

		$c=$_POST['nLitigante'];
		$d = str_replace('-', '', $c );

		$e=$_POST['nCedula'];
		$f = str_replace('-', '', $e );

		$g=$_POST['nCedulaE'];
		$h = str_replace('-', '', $g );
		
		$doc1=$this->request->getFile('cedulaFederalFrontal');
		$doc2=$this->request->getFile('cedulaFederalPosterior');
		$doc3=$this->request->getFile('cedulaEstatalFrontal');
		$doc4=$this->request->getFile('cedulaEstatalPosterior');
		$doc5=$this->request->getFile('fotoreciente');

		$nomDoc1=$this->request->getPost('fF');
		$nomDoc2=$this->request->getPost('fP');
		$nomDoc3=$this->request->getPost('eF');
		$nomDoc4=$this->request->getPost('eP');
		$nomDoc5=$this->request->getPost('reciente');


		$extf_Fede=$this->request->getPost('extf_Fede');
		$extp_Fede=$this->request->getPost('extp_Fede');
		$extf_Estatal=$this->request->getPost('extf_Estatal');
		$extp_estatal=$this->request->getPost('extp_estatal');
		

		if ($doc1 != ""){

			$doc1=$this->request->getFile('cedulaFederalFrontal');

			$archivo_name=$_FILES['cedulaFederalFrontal']['name'];

			$extension = explode(".",$archivo_name);
			$num = count($extension)-1;

			
			
			
			

				//borrar archivo en caso de que ya exista 
				$rutaDoc1 = "./dist/img/cedulaLitigante/$folioLitigante-cedulaFederalFrontal.$extension[$num]";
				

				if (file_exists($rutaDoc1)){

					unlink($rutaDoc1);
					$carpeta="./dist/img/cedulaLitigante";
					if (!file_exists($carpeta)){

						mkdir($carpeta,077,true);
					}

				}
				
											


			$doc1->move("./dist/img/cedulaLitigante", "$folioLitigante-cedulaFederalFrontal.$extension[$num]");
			

			


			$nomDoc1="$folioLitigante-cedulaFederalFrontal.$extension[$num]";
			$extf_Fede="$extension[$num]";

		
			
			

						//----------------------------------------------insertamos 

		}






		if ($doc2 != ""){

			$doc2=$this->request->getFile('cedulaFederalPosterior');
			$archivo_name2=$_FILES['cedulaFederalPosterior']['name'];

			$extension2 = explode(".",$archivo_name2);
			$num2 = count($extension2)-1;
			
			

				//borrar archivo en caso de que ya exista 
				$rutaDoc2 = "./dist/img/cedulaLitigante/$folioLitigante-cedulaFederalPosterior.$extension2[$num2]";
				

				if (file_exists($rutaDoc2)){

					unlink($rutaDoc2);
					$carpeta="./dist/img/cedulaLitigante";
					if (!file_exists($carpeta)){

						mkdir($carpeta,077,true);
					}

				}
				
											


			$doc2->move("./dist/img/cedulaLitigante", "$folioLitigante-cedulaFederalPosterior.$extension2[$num2]");
			


			$nomDoc2="$folioLitigante-cedulaFederalPosterior.$extension2[$num2]";
			$extp_Fede="$extension2[$num2]";
			

						//----------------------------------------------insertamos 

		}



		if ($doc3 != ""){

			$doc3=$this->request->getFile('cedulaEstatalFrontal');


			$archivo_name3=$_FILES['cedulaEstatalFrontal']['name'];

			$extension3 = explode(".",$archivo_name3);
			$num3 = count($extension3)-1;
			
			
			

				//borrar archivo en caso de que ya exista 
				$rutaDoc3 = "./dist/img/cedulaLitigante/$folioLitigante-cedulaEstatalFrontal.$extension3[$num3]";
				

				if (file_exists($rutaDoc3)){

					unlink($rutaDoc3);
					$carpeta="./dist/img/cedulaLitigante";
					if (!file_exists($carpeta)){

						mkdir($carpeta,077,true);
					}

				}
				
											


			$doc3->move("./dist/img/cedulaLitigante", "$folioLitigante-cedulaEstatalFrontal.$extension3[$num3]");
			


			$nomDoc3="$folioLitigante-cedulaEstatalFrontal.$extension3[$num3]";
			$extf_Estatal="$extension3[$num3]";
			

						//----------------------------------------------insertamos 

		}




		if ($doc4 != ""){

			$doc4=$this->request->getFile('cedulaEstatalPosterior');
			$archivo_name4=$_FILES['cedulaEstatalPosterior']['name'];

			$extension4 = explode(".",$archivo_name4);
			$num4 = count($extension4)-1;

				//borrar archivo en caso de que ya exista 
				$rutaDoc4 = "./dist/img/cedulaLitigante/$folioLitigante-cedulaEstatalPosterior.$extension4[$num4]";
				

				if (file_exists($rutaDoc4)){

					unlink($rutaDoc4);
					$carpeta="./dist/img/cedulaLitigante";
					if (!file_exists($carpeta)){

						mkdir($carpeta,077,true);
					}

				}
				
											


			$doc4->move("./dist/img/cedulaLitigante", "$folioLitigante-cedulaEstatalPosterior.$extension4[$num4]");
			


			$nomDoc4="$folioLitigante-cedulaEstatalPosterior.$extension4[$num4]";

			$extp_estatal="$extension4[$num4]";
			

						//----------------------------------------------insertamos 

		}


		if ($doc5 != ""){

			$doc5=$this->request->getFile('fotoreciente');
			

				//borrar archivo en caso de que ya exista 
				$rutaDoc5 = "./dist/img/cedulaLitigante/$folioLitigante-fotoreciente.png";
				

				if (file_exists($rutaDoc5)){

					unlink($rutaDoc5);
					$carpeta="./dist/img/cedulaLitigante";
					if (!file_exists($carpeta)){

						mkdir($carpeta,077,true);
					}

				}
				
											


			$doc5->move("./dist/img/cedulaLitigante", "$folioLitigante-fotoreciente.png");
			


			$nomDoc5="$folioLitigante-fotoreciente.png";
			

						//----------------------------------------------insertamos 

		}





























		
		$id=$this->request->getPost('id');
		


		$this->usuarios->update($id,['nombre'=>$this->request->getPost('nombre'),
															   'apellidoP'=>$this->request->getPost('apellidoP'),
															   'apellidoM'=>$this->request->getPost('apellidoM'),
															   'correo'=>$this->request->getPost('correo'),															   
															   'usuario'=>$this->request->getPost('usuario'),
															   'id_rol'=>$this->request->getPost('rol'),


															   'nCel'=>$b,
			                                                   'nLitigante'=>$d,
			                                                   'nCedula'=>$f,
			                                                   'nCedulaE'=>$h,

															   'nomCedulaFrontalF'=>$nomDoc1,

															   'extf_Fede'=>$extf_Fede,
															   'extp_Fede'=> $extp_Fede,
															   'extf_Estatal'=>$extf_Estatal,

															   'extp_Estatal'=> $extp_estatal,
															   

															   'extf_Estatal'=>$extf_Estatal,
			                                                   'nomCedulaFrontalE'=>$nomDoc3,
			                                                   'nomCedulaPosteriorF'=>$nomDoc2,
			                                                   'nomCedulaPosteriorE'=>$nomDoc4,
			                                                   'nomFotoReciente'=>$nomDoc5,	
															  
															
															]);

		


		return redirect()->to(base_url().'/usuarios/editar/'.$id.'');
		
		
        
		
	}



//--------------------------------------------------------------------------------------------------------------------------------------------------------------
public function eliminar($id){
        
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
     $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'UsuariosEliminar');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/usuarios');
           
           
            
        }
		
		
		$this->usuarios->update($id,['activo'=> 0]);
		return redirect()->to(base_url().'/usuarios');
		
		
        
		
	}
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
public function eliminados($activo=0){
		
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
    $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'UsuariosEliminados');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/usuarios');
           
           
            
        }
		$roles = $this->roles->where('activo',1)->findAll();
		$caja=$this->cajas->where('activo',1)->findAll();
		
		$usuarios=$this->usuarios->where('activo',$activo)->findAll();
		$data=['titulo'=>'Usuarios eliminadas','datos'=>$usuarios, 'rol'=>$roles, 'caj'=>$caja];
		
		
        echo view('header');
		echo view('usuarios/eliminadas', $data);
		echo view('footer');
		
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function reingresar($id){
        
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		
		
		$this->usuarios->update($id,['activo'=> 1]);
		return redirect()->to(base_url().'/usuarios');
		
		
        
		
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function login(){


		echo view('header');
		echo view('Inicio');
		echo view('footer');

		
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
public function valida(){
		
		if($this->request->getMethod()=="post" && $this->validate($this->reglas2)){
			
			$usuarios=$this->request->getPost('usuario');
			$contra=$this->request->getPost('pass');
			
			$consultaUsuarios= $this->usuarios->where('usuario',$usuarios)->first();
			
			if($consultaUsuarios != null){
				if(password_verify($contra, $consultaUsuarios['password'])){
					
					$datosSesion=[
						'id_id'=>$consultaUsuarios['id'],
						'id_usuario'=>$consultaUsuarios['usuario'],
						'id_nombre'=>$consultaUsuarios['nombre'],
						
						'id_rol'=>$consultaUsuarios['id_rol']
					
					];
                    
                    $ip=$_SERVER['REMOTE_ADDR'];
                    $detalles=$_SERVER['HTTP_USER_AGENT'];
                    
                    $this->logss->save([
                        'id_usuario'=>$consultaUsuarios['id'],
                        'evento'=>'Inicio de sesión',
                        'ip'=>$ip,
                        'detalles'=>$detalles,
                    ]);
					
					$session=session();
					$session->set($datosSesion);
					return redirect()->to(base_url().'/inicio');
					
					
				}else {
					
					$data['error']="&nbsp;&nbsp;La contraseña no coinciden";
					echo view('login',$data);
					
				}
				
				
			}else{
				
				
				$data['error']="&nbsp;&nbsp;El usuario no existe";
				echo view('login',$data);
			}
			
		}
		else {
			
			$data=['validation'=> $this->validator];
			
				echo view('login',$data);
				
				
		}
	}








	// public function valida(){
		
	// 	if($this->request->getMethod()=="post" && $this->validate($this->reglas2)){
			
	// 		$usuarios=$this->request->getPost('usuario');
	// 		$contra=$this->request->getPost('pass');
			
	// 		$consultaUsuarios= $this->usuarios->where('usuario',$usuarios)->first();
			
	// 		if($consultaUsuarios != null){
	// 			if(password_verify($contra, $consultaUsuarios['password'])){
					
	// 				$datosSesion=[
	// 					'id_id'=>$consultaUsuarios['id'],
	// 					'id_usuario'=>$consultaUsuarios['usuario'],
	// 					'id_nombre'=>$consultaUsuarios['nombre'],
						
	// 					'id_rol'=>$consultaUsuarios['id_rol']
					
	// 				];
                    
    //                 $ip=$_SERVER['REMOTE_ADDR'];
    //                 $detalles=$_SERVER['HTTP_USER_AGENT'];
                    
    //                 $this->logss->save([
    //                     'id_usuario'=>$consultaUsuarios['id'],
    //                     'evento'=>'Inicio de sesión',
    //                     'ip'=>$ip,
    //                     'detalles'=>$detalles,
    //                 ]);
					
	// 				$session=session();
	// 				$session->set($datosSesion);
	// 				return redirect()->to(base_url().'/inicio');
					
					
	// 			}else {
					
	// 				$data['error']="&nbsp;&nbsp;La contraseña no coinciden";
	// 				echo view('login',$data);
					
	// 			}
				
				
	// 		}else{
				
				
	// 			$data['error']="&nbsp;&nbsp;El usuario no existe";
	// 			echo view('login',$data);
	// 		}
			
	// 	}
	// 	else {
			
	// 		$data=['validation'=> $this->validator];
			
	// 			echo view('login',$data);
				
				
	// 	}
	// }
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function logout(){
		
		
		
	
		
		$session= session();
        
         $ip=$_SERVER['REMOTE_ADDR'];
                    $detalles=$_SERVER['HTTP_USER_AGENT'];
                    
                    $this->logss->save([
                        'id_usuario'=> $session->id_id,
                        'evento'=>'Cierre de sesión',
                        'ip'=>$ip,
                        'detalles'=>$detalles,
                    ]);
					
        
        
		$session->destroy();
		return redirect()->to(base_url());

	}
	
	
	
	

	
	
	
	
	
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function editarCont(){
        
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        
		
		$sessionN =session();
			
		$usuario=$this->usuarios->where('id',$sessionN->id_id)->first();

		$data=['titulo'=>'Cambiar contraseña','sesion'=>$usuario];
		
		
        echo view('header');
		echo view('usuarios/editarCont', $data);
		echo view('footer');
		
	}
	
	

	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function actualizarCont(){
        
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		
		
		if($this->request->getMethod()=="post" && $this->validate($this->reglas3)){
			 $sessionRT=session();
			$id=$sessionRT->id_id;
			
			$hash=password_hash($this->request->getPost('pass'),PASSWORD_DEFAULT);
			
			$this->usuarios->update($id,['password'=>$hash]);
			
		$usuario=$this->usuarios->where('id',$sessionRT->id_id)->first();

		$data=['titulo'=>'Cambiar contraseña','sesion'=>$usuario, 'mensaje'=>'Contraseña actualizada'];
		
		
        echo view('header');
		echo view('usuarios/editarCont', $data);
		echo view('footer');
		
			
		}
		
		else {
			
				$sessionN =session();
			
		$usuario=$this->usuarios->where('id',$sessionN->id_id)->first();

		$data=['titulo'=>'Cambiar contraseña','sesion'=>$usuario, 'validation'=> $this->validator];
		
		
        echo view('header');
		echo view('usuarios/editarCont', $data);
		echo view('footer');
		
			

			
			
		}
		
        
		
		
		
	}
	
	
	
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function actualizarCont2(){
        
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        
		
		
        if($this->request->getMethod()=="post" && $this->validate($this->reglas3)){
		
			
			$hash=password_hash($this->request->getPost('pass'),PASSWORD_DEFAULT);
			
		$this->usuarios->update($this->request->getPost('id'),['password'=>$hash]);
		return redirect()->to(base_url().'/usuarios');
		
		
		}else{
			
			return $this->editarCont2($this->request->getPost('id'),$this->validator);
			
		}
		
	}
	
		
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function editarCont2($id, $valid=null){
		
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'UsuariosEditarContraseña');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/usuarios');
           
           
            
        }

		$usuario = $this->usuarios->where('id',$id)->first();
		
		if($valid != null){
			$data=['titulo'=>'Editar usuario', 'usuario'=>$usuario,'validation'=> $valid];
		}
		else {
			$data=['titulo'=>'Editar usuario', 'usuario'=>$usuario ];
		}
		
		
		
        echo view('header');
		echo view('usuarios/editarCont2', $data);
		echo view('footer');
		
	}
	
	
	
	
	

}

?>