<?php 

namespace App\Controllers;
use App\Models\juzgadosModels;
use App\Models\detalle_roles_permisosModels;
use App\Models\EstadosModels;

class Juzgados extends BaseController{
	
	protected $juzgados;
	protected $reglas,$session,$detalleRolesPermisos;
    protected $estados;
	
	public function __construct(){
		
		$this->juzgados=new JuzgadosModels();
        $this->session=session();
        $this->detalleRolesPermisos=new detalle_roles_permisosModels();
         $this->estados=new EstadosModels();
	helper(['form']);
		$this->reglas=[
			'juzgado'=>[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.'
					   ]
			]
			
			];
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
public function index($activo=1){
        

if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
    
    $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'SubCategorias');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/inicio');
           
           
            
        }
		$categorias=$this->juzgados->where('activo',$activo)->findAll();
        $estados=$this->estados->findAll();
		$data=['titulo'=>'Juzgados registrados','datos'=>$categorias,'estados'=>$estados];
		
		
        echo view('header');
		echo view('juzgados/juzgados', $data);
		echo view('footer');
		
	}
	
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
public function agregar(){
        

if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }

     $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'CategoriasAgregar');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/juzgados');
           
           
            
        }
    
    
    
    
		
		
		$data=['titulo'=>'Agregar nuevo Juzgado'];
		
		
        echo view('header');
		echo view('juzgados/agregar', $data);
		echo view('footer');
		
	}

//--------------------------------------------------------------------------------------------------------------------------------------------------------------

	public function insertar(){
		

if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		if($this->request->getMethod()=="post" && $this->validate($this->reglas)){


			$a=$_POST['telefono'];
			$b = str_replace('-', '', $a );
			
		$this->juzgados->save(['juzgado'=> $this->request->getPost('juzgado'),
                               'abreviatura'=> $this->request->getPost('abreviatura'),
                               'adscripcion'=> $this->request->getPost('adscripcion'),
                               'direccion'=> $this->request->getPost('direccion'),
                               'id_estado'=> $this->request->getPost('estado'),
                               'ciudad'=> $this->request->getPost('ciudad'),

                               'telefono'=> $b,
                               'cp'=> $this->request->getPost('cp')]);
		return redirect()->to(base_url().'/juzgados');
		
		}else{
			
			$data=['titulo'=>'Agregar nuevo Tipo de Juicio', 'validation'=> $this->validator];
		
		
        echo view('header');
		echo view('juzgados/agregar', $data);
		echo view('footer');
		
			
		}
        
		
	}
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	
	public function editar($id, $valid=null){
        

if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'CategoriasEditar');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/juicios');
           
           
            
        }
		
		$unidad=$this->juicios->where('id',$id)->first();
		
		if($valid != null){
		$data=['titulo'=>'Editar Tipo de Juicio', 'datos'=>$unidad,'validation'=> $valid];
		}else{
			$data=['titulo'=>'Editar Tipo de Juicio', 'datos'=>$unidad];
			
		}
		
        echo view('header');
		echo view('juicios/editar', $data);
		echo view('footer');
		
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	
	public function actualizar(){
		

if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		if($this->request->getMethod()=="post" && $this->validate($this->reglas)){


			$a=$_POST['telefono'];
			$b = str_replace('-', '', $a );

		$this->juzgados->update($this->request->getPost('id'),[
			'juzgado'=> $this->request->getPost('juzgado'),
			'abreviatura'=> $this->request->getPost('abreviatura'),
			'adscripcion'=> $this->request->getPost('adscripcion'),
			'direccion'=> $this->request->getPost('direccion'),
			'direccion'=> $this->request->getPost('direccion'),
			'estado'=> $this->request->getPost('estado'),
			'ciudad'=> $this->request->getPost('ciudad'),
			'telefono'=> $b,
			'cp'=> $this->request->getPost('cpEdit')]);
		return redirect()->to(base_url().'/juzgados');
		
		}else{
			
			return $this->editar($this->request->getPost('id'),$this->validator);
			
		}
        
		
	}
	
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function eliminar($id){
        

if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		
        $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'CategoriasEliminar');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/juzgados');
           
           
            
        }
		
		$this->juzgados->update($id,['activo'=> 0]);
		return redirect()->to(base_url().'/juzgados');
		
		
        
		
	}
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------	
	public function eliminados($activo=0){
        

if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        
        $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'CategoriasEliminados');
		
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/juzgados');
           
           
            
        }
		$categorias=$this->juzgados->where('activo',$activo)->findAll();
		$estados=$this->estados->findAll();
		$data=['titulo'=>'Juzgados eliminados','datos'=>$categorias, 'estados'=>$estados];
		
		
		
        echo view('header');
		echo view('juzgados/eliminadas', $data);
		echo view('footer');
		
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	
		public function reingresar($id){
            

if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		
		
		$this->juzgados->update($id,['activo'=> 1]);
		return redirect()->to(base_url().'/juzgados');
		
		
        
		
	}
	
	
	
}






?>