<?php 

namespace App\Controllers;
use App\Models\clientesjModels;
use App\Models\detalle_roles_permisosModels;
use App\Models\PaisModels;
use App\Models\EstadosModels;
use App\Models\ContactoconclienteModels;
use App\Models\expedienteModels;

class Clientesj extends BaseController{
	
	protected $clientesj;
    protected $pais,$estados,$contactoconcliente, $expediente;
	protected $reglas,$session,$detalleRolesPermisos;
	

	
	
	public function __construct(){
		
		$this->clientesj=new ClientesjModels();
        $this->pais=new PaisModels();
        $this->estados=new EstadosModels();
          $this->contactoconcliente=new ContactoconclienteModels();

		  $this->expediente=new expedienteModels();

        $this->session=session();
        $this->detalleRolesPermisos=new detalle_roles_permisosModels();
	
		helper(['form','upload']);
		$this->reglas=[
			'nombre'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.'
					   ]
				],
			'direccion'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo UNIDAD es obligatorio.'
					   ]
				],
			'telefono'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo CATEGORIA es obligatorio.'
					   ]
				],
			'correo'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo PRECIO VENTA es obligatorio.'
					   ]
				]	
			];
		
		
		
		
		
		
		
	}
	
	
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------	
	public function index($activo=1, $activo2=null){
        if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'MenuClientes');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/inicio');
           
           
            
        }
        
        
        
		$clientesj=$this->clientesj->where('activo',$activo);
		
		$clientesj=$this->clientesj->where('id_expediente',$activo2)->findAll();
        
		
		$join=$this->clientesj->getDatos();
		
		$paiss=$this->pais->findAll();
        $estadoss=$this->estados->findAll();
        $contactocliente=$this->contactoconcliente->findAll();
		$expedientess=$this->expediente->findAll();




		$data=['titulo'=>'Catálogo de clientes','datos'=>$clientesj,'pais'=>$paiss,'estados'=>$estadoss,'contactoCliente'=>$contactocliente,'expedienteDigital'=>$expedientess,'nuevos'=>$join];
		
		
        echo view('header');
		echo view('clientesj/clientesj', $data);
		echo view('footer');
		
	}
	
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function agregar(){
        if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
         $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'ClientesAgregar');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/clientes');
           
           
            
        }


		
		$contactocliente=$this->contactoconcliente->findAll();
		$estadoss=$this->estados->findAll();
		
		$data=['titulo'=>'Agregar cliente', 'contactoCliente'=>$contactocliente,'estados'=>$estadoss];
		
		
        echo view('header');
		echo view('clientesj/agregar', $data);
		echo view('footer');
		
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function insertarMoral(){
        if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		
			if($this->request->getMethod()=="post"){
		
				$a=$_POST['telefono'];
				$b = str_replace('-', '', $a );
				$c=$_POST['celular'];
				$d= str_replace('-', '', $c );

				
			$this->clientesj->save(['nombre'=> $this->request->getPost('nombre'),
									'id_contacto'=>$this->request->getPost('id_contacto'),
									
									'calle'=>$this->request->getPost('calle'),
									'cp'=>$this->request->getPost('cp'),
									'colonia'=>$this->request->getPost('colonia'),
									'ciudad'=>$this->request->getPost('ciudad'),
									'id_estado'=>$this->request->getPost('estado'),
									
									'telefono'=>$b,
									'celular'=>$d,
									'email'=>$this->request->getPost('email'),
									'rfc'=>$this->request->getPost('rfc'),
									'registroPatronal'=>$this->request->getPost('regPatronal'),
									'sucursalM'=>$this->request->getPost('sucursalM'),
									'comentarios'=>$this->request->getPost('comentarios'),
									'moral_fisica'=>$this->request->getPost('tipo'),
									]);
			
						
		return redirect()->to(base_url().'/clientesj');
			
		}
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
public function insertarfisica(){
	if (!isset($this->session->id_usuario)){
		return redirect()->to(base_url());
	}
	
		if($this->request->getMethod()=="post"){



			$folioLitigante=$_POST['folioLitigante'];
	
			$a=$_POST['telefono'];
			$b = str_replace('-', '', $a );
			$c=$_POST['celular'];
			$d= str_replace('-', '', $c );

			$logoCliente=$this->request->getFile('logoCliente');
			$ideOficial=$this->request->getFile('ideOficial');
			$curpAR=$this->request->getFile('curpAR');
			$ConstanciaFiscal=$this->request->getFile('ConstanciaFiscal');
			$AperturaEstablecimiento=$this->request->getFile('AperturaEstablecimiento');
			$LicMunicipal=$this->request->getFile('LicMunicipal');
			$ComprobanteDomicilio=$this->request->getFile('ComprobanteDomicilio');
			$PoderAbogado=$this->request->getFile('PoderAbogado');
			$RegRep=$this->request->getFile('RegRep');

			$logoCliente_nom=0;
			$ideOficial_nom=0;
			$curpAR_nom=0;
			$ConstanciaFiscal_nom=0;
			$AperturaEstablecimiento_nom=0;
			$LicMunicipal_nom=0;
			$ComprobanteDomicilio_nom=0;
			$PoderAbogado_nom=0;
			$RegRep_nom=0;

			
			$logoCliente_ext="";
			$ideOficial_ext="";
			$curpAR_ext="";
			$ConstanciaFiscal_ext="";
			$AperturaEstablecimiento_ext="";

			$LicMunicipal_ext="";
			$ComprobanteDomicilio_ext="";
			$PoderAbogado_ext="";
			$RegRep_ext="";





			
			if ($logoCliente != ""){

				$logoCliente=$this->request->getFile('logoCliente');
				
				$archivo_name=$_FILES['logoCliente']['name'];
				
				$extension = explode(".",$archivo_name);
				$num = count($extension)-1;
				
				
				
				
				
				
					//borrar archivo en caso de que ya exista 
					$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-logoCliente.$extension[$num]";
					
				
					if (file_exists($rutaDoc)){
				
						unlink($rutaDoc);
						$carpeta="./dist/img/cliente/expediente/";
						if (!file_exists($carpeta)){
				
							mkdir($carpeta,077,true);
						}
				
					}
					
												
				
				
				$logoCliente->move("./dist/img/cliente/expediente/", "$folioLitigante-logoCliente.$extension[$num]");
				
				
				
				
				
				$logoCliente_nom="$folioLitigante-logoCliente.$extension[$num]";
				$logoCliente_ext="$extension[$num]";
				
				
				
				
				
							//----------------------------------------------insertamos 
				
				}




			if ($ideOficial != ""){

				$ideOficial=$this->request->getFile('ideOficial');
				
				$archivo_name=$_FILES['ideOficial']['name'];
				
				$extension = explode(".",$archivo_name);
				$num = count($extension)-1;
				
				
				
				
				
				
					//borrar archivo en caso de que ya exista 
					$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-ideOficial.$extension[$num]";
					
				
					if (file_exists($rutaDoc)){
				
						unlink($rutaDoc);
						$carpeta="./dist/img/cliente/expediente/";
						if (!file_exists($carpeta)){
				
							mkdir($carpeta,077,true);
						}
				
					}
					
												
				
				
				$ideOficial->move("./dist/img/cliente/expediente/", "$folioLitigante-ideOficial.$extension[$num]");
				
				
				
				
				
				$ideOficial_nom="$folioLitigante-ideOficial.$extension[$num]";
				$ideOficial_ext="$extension[$num]";
				
				
				
				
				
							//----------------------------------------------insertamos 
				
				}


				if ($curpAR != ""){

					$curpAR=$this->request->getFile('curpAR');
					
					$archivo_name=$_FILES['curpAR']['name'];
					
					$extension = explode(".",$archivo_name);
					$num = count($extension)-1;
					
					
					
					
					
					
						//borrar archivo en caso de que ya exista 
						$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-curpAR.$extension[$num]";
						
					
						if (file_exists($rutaDoc)){
					
							unlink($rutaDoc);
							$carpeta="./dist/img/cliente/expediente/";
							if (!file_exists($carpeta)){
					
								mkdir($carpeta,077,true);
							}
					
						}
						
													
					
					
					$curpAR->move("./dist/img/cliente/expediente/", "$folioLitigante-curpAR.$extension[$num]");
					
					
					
					
					
					$curpAR_nom="$folioLitigante-curpAR.$extension[$num]";
					$curpAR_ext="$extension[$num]";
					
					
					
					
					
								//----------------------------------------------insertamos 
					
					}





					if ($ConstanciaFiscal != ""){

						$ConstanciaFiscal=$this->request->getFile('ConstanciaFiscal');
						
						$archivo_name=$_FILES['ConstanciaFiscal']['name'];
						
						$extension = explode(".",$archivo_name);
						$num = count($extension)-1;
						
						
						
						
						
						
							//borrar archivo en caso de que ya exista 
							$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-ConstanciaFiscal.$extension[$num]";
							
						
							if (file_exists($rutaDoc)){
						
								unlink($rutaDoc);
								$carpeta="./dist/img/cliente/expediente/";
								if (!file_exists($carpeta)){
						
									mkdir($carpeta,077,true);
								}
						
							}
							
														
						
						
						$ConstanciaFiscal->move("./dist/img/cliente/expediente/", "$folioLitigante-ConstanciaFiscal.$extension[$num]");
						
						
						
						
						
						$ConstanciaFiscal_nom="$folioLitigante-ConstanciaFiscal.$extension[$num]";
						$ConstanciaFiscal_ext="$extension[$num]";
						
						
						
						
						
									//----------------------------------------------insertamos 
						
						}


						if ($AperturaEstablecimiento != ""){

							$AperturaEstablecimiento=$this->request->getFile('AperturaEstablecimiento');
							
							$archivo_name=$_FILES['AperturaEstablecimiento']['name'];
							
							$extension = explode(".",$archivo_name);
							$num = count($extension)-1;
							
							
							
							
							
							
								//borrar archivo en caso de que ya exista 
								$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-AperturaEstablecimiento.$extension[$num]";
								
							
								if (file_exists($rutaDoc)){
							
									unlink($rutaDoc);
									$carpeta="./dist/img/cliente/expediente/";
									if (!file_exists($carpeta)){
							
										mkdir($carpeta,077,true);
									}
							
								}
								
															
							
							
							$AperturaEstablecimiento->move("./dist/img/cliente/expediente/", "$folioLitigante-AperturaEstablecimiento.$extension[$num]");
							
							
							
							
							
							$AperturaEstablecimiento_nom="$folioLitigante-AperturaEstablecimiento.$extension[$num]";
							$AperturaEstablecimiento_ext="$extension[$num]";
							
							
							
							
							
										//----------------------------------------------insertamos 
							
							}




							if ($LicMunicipal != ""){

								$LicMunicipal=$this->request->getFile('LicMunicipal');
								
								$archivo_name=$_FILES['LicMunicipal']['name'];
								
								$extension = explode(".",$archivo_name);
								$num = count($extension)-1;
								
								
								
								
								
								
									//borrar archivo en caso de que ya exista 
									$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-LicMunicipal.$extension[$num]";
									
								
									if (file_exists($rutaDoc)){
								
										unlink($rutaDoc);
										$carpeta="./dist/img/cliente/expediente/";
										if (!file_exists($carpeta)){
								
											mkdir($carpeta,077,true);
										}
								
									}
									
																
								
								
								$LicMunicipal->move("./dist/img/cliente/expediente/", "$folioLitigante-LicMunicipal.$extension[$num]");
								
								
								
								
								
								$LicMunicipal_nom="$folioLitigante-LicMunicipal.$extension[$num]";
								$LicMunicipal_ext="$extension[$num]";
								
								
								
								
								
											//----------------------------------------------insertamos 
								
								}



								if ($ComprobanteDomicilio != ""){

									$ComprobanteDomicilio=$this->request->getFile('ComprobanteDomicilio');
									
									$archivo_name=$_FILES['ComprobanteDomicilio']['name'];
									
									$extension = explode(".",$archivo_name);
									$num = count($extension)-1;
									
									
									
									
									
									
										//borrar archivo en caso de que ya exista 
										$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-ComprobanteDomicilio.$extension[$num]";
										
									
										if (file_exists($rutaDoc)){
									
											unlink($rutaDoc);
											$carpeta="./dist/img/cliente/expediente/";
											if (!file_exists($carpeta)){
									
												mkdir($carpeta,077,true);
											}
									
										}
										
																	
									
									
									$ComprobanteDomicilio->move("./dist/img/cliente/expediente/", "$folioLitigante-ComprobanteDomicilio.$extension[$num]");
									
									
									
									
									
									$ComprobanteDomicilio_nom="$folioLitigante-ComprobanteDomicilio.$extension[$num]";
									$ComprobanteDomicilio_ext="$extension[$num]";
									
									
									
									
									
												//----------------------------------------------insertamos 
									
									}





									if ($PoderAbogado != ""){

										$PoderAbogado=$this->request->getFile('PoderAbogado');
										
										$archivo_name=$_FILES['PoderAbogado']['name'];
										
										$extension = explode(".",$archivo_name);
										$num = count($extension)-1;
										
										
										
										
										
										
											//borrar archivo en caso de que ya exista 
											$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-PoderAbogado.$extension[$num]";
											
										
											if (file_exists($rutaDoc)){
										
												unlink($rutaDoc);
												$carpeta="./dist/img/cliente/expediente/";
												if (!file_exists($carpeta)){
										
													mkdir($carpeta,077,true);
												}
										
											}
											
																		
										
										
										$PoderAbogado->move("./dist/img/cliente/expediente/", "$folioLitigante-PoderAbogado.$extension[$num]");
										
										
										
										
										
										$PoderAbogado_nom="$folioLitigante-PoderAbogado.$extension[$num]";
										$PoderAbogado_ext="$extension[$num]";
										
										
										
										
										
													//----------------------------------------------insertamos 
										
										}


										if ($RegRep != ""){

											$RegRep=$this->request->getFile('RegRep');
											
											$archivo_name=$_FILES['RegRep']['name'];
											
											$extension = explode(".",$archivo_name);
											$num = count($extension)-1;
											
											
											
											
											
											
												//borrar archivo en caso de que ya exista 
												$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-RegRep.$extension[$num]";
												
											
												if (file_exists($rutaDoc)){
											
													unlink($rutaDoc);
													$carpeta="./dist/img/cliente/expediente/";
													if (!file_exists($carpeta)){
											
														mkdir($carpeta,077,true);
													}
											
												}
												
																			
											
											
											$RegRep->move("./dist/img/cliente/expediente/", "$folioLitigante-RegRep.$extension[$num]");
											
											
											
											
											
											$RegRep_nom="$folioLitigante-RegRep.$extension[$num]";
											$RegRep_ext="$extension[$num]";
											
											
											
											
											
														//----------------------------------------------insertamos 
											
											}
	

















			
		$this->clientesj->save(['nombre'=> $this->request->getPost('nombre'),
								'folioCliente'=>$folioLitigante,
								'id_contacto'=>$this->request->getPost('id_contacto'),
								
								'calle'=>$this->request->getPost('calle'),
								'cp'=>$this->request->getPost('cp'),
								'colonia'=>$this->request->getPost('colonia'),
								'ciudad'=>$this->request->getPost('ciudad'),
								'id_estado'=>$this->request->getPost('estado'),
								
								'telefono'=>$b,
								'celular'=>$d,
								'email'=>$this->request->getPost('email'),
								'rfc'=>$this->request->getPost('rfc'),
								'registroPatronal'=>$this->request->getPost('regPatronal'),
								'curp'=>$this->request->getPost('curp'),
								'comentarios'=>$this->request->getPost('comentarios'),
								'moral_fisica'=>$this->request->getPost('tipo'),

								//nombres de documentos y extensiones
								'logoCliente'=>$logoCliente_nom,
								'logoCliente_ext'=>$logoCliente_ext, 
								'ideOficial_nom'=>$ideOficial_nom,
								'ideOficial_ext'=>$ideOficial_ext,
								'curpAR_nom'=>$curpAR_nom,
								'curpAR_ext'=>$curpAR_ext,
								'ConstanciaFiscal_nom'=>$ConstanciaFiscal_nom,
								'ConstanciaFiscal_ext'=>$ConstanciaFiscal_ext,
								'AperturaEstablecimiento_nom'=>$AperturaEstablecimiento_nom,
								'AperturaEstablecimiento_ext'=>$AperturaEstablecimiento_ext,
								'LicMunicipal_nom'=>$LicMunicipal_nom,
								'LicMunicipal_ext'=>$LicMunicipal_ext,
								'ComprobanteDomicilio_nom'=>$ComprobanteDomicilio_nom,
								'ComprobanteDomicilio_ext'=>$ComprobanteDomicilio_ext,
								'PoderAbogado_nom'=>$PoderAbogado_nom,
								'PoderAbogado_ext'=>$PoderAbogado_ext,
								'RegRep_nom'=>$RegRep_nom,
								'RegRep_ext'=>$RegRep_ext,



								]);
		
					
	return redirect()->to(base_url().'/clientesj');
		
	}
}
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function insertar2(){

        if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		
			if($this->request->getMethod()=="post"){
		
		
				$a=$_POST['telefono'];
				$b = str_replace('-', '', $a );

			$this->contactoconcliente->save(['nombre'=>$this->request->getPost('nombre'),
									'apellidoP'=>$this->request->getPost('apellidoP'),
									'apellidoM'=>$this->request->getPost('apellidoM'),
                                    'celular'=>$b,
                                    'correo'=>$this->request->getPost('Email'),
                                    'empresa'=>$this->request->getPost('empresa')
									
									]);
			
                
                
                
		return redirect()->to(base_url().'/clientesj/agregar');
			
		}
		
		
        
		
	}
	
	
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
public function detalles($id, $valid=null){
	if (!isset($this->session->id_usuario)){
		return redirect()->to(base_url());
	}
   $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'ClientesEditar');
	
	if(!$permiso){
		
		
		
		
		return redirect()->to(base_url().'/clientes');
	   
	   
		
	}
	












	$estadoss=$this->estados->findAll();
	$contactocliente=$this->contactoconcliente->findAll();
	$clientesj=$this->clientesj->where('id',$id)->first();
	




	$data=['titulo'=>'Catálogo de clientes','datos'=>$clientesj,'estados'=>$estadoss,'contactoCliente'=>$contactocliente];
	










	
	
	

	echo view('header');
	echo view('clientesj/detalles', $data);
	echo view('footer');
	
}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------















//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function editar($id, $valid=null){
        if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
       $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'ClientesEditar');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/clientes');
           
           
            
        }
		
		
		$clientes=$this->clientesj->where('id',$id)->first();
		
		if($valid != null){
		$data=['titulo'=>'Editar cliente','clientes'=>$clientes,'validation'=> $valid ];
		
		}else{
		$data=['titulo'=>'Editar cliente','clientes'=>$clientes ];	
			
		}
        echo view('header');
		echo view('clientes/editar', $data);
		echo view('footer');
		
	}

//--------------------------------------------------------------------------------------------------------------------------------------------------------------
public function editarE($id, $valid=null){
	if (!isset($this->session->id_usuario)){
		return redirect()->to(base_url());
	}
   $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'ClientesEditar');
	
	if(!$permiso){
		
		
		
		
		return redirect()->to(base_url().'/clientes');
	   
	   
		
	}
	












	$estadoss=$this->estados->findAll();
	$contactocliente=$this->contactoconcliente->findAll();
	$clientesj=$this->clientesj->where('id',$id)->first();
	




	$data=['titulo'=>'Catálogo de clientes','datos'=>$clientesj,'estados'=>$estadoss,'contactoCliente'=>$contactocliente];
	










	
	
	

	echo view('header');
	echo view('clientesj/editar', $data);
	echo view('footer');
	
}


//--------------------------------------------------------------------------------------------------------------------------------------------------------------
public function actualizarfisica(){
	if (!isset($this->session->id_usuario)){
		return redirect()->to(base_url());
	}
	
		if($this->request->getMethod()=="post"){



			$folioLitigante=$_POST['folioLitigante'];
	
			$a=$_POST['telefono'];
			$b = str_replace('-', '', $a );
			$c=$_POST['celular'];
			$d= str_replace('-', '', $c );

			
			

			$logoCliente=$this->request->getFile('logoCliente');
			$ideOficial=$this->request->getFile('ideOficial');
			
			$curpAR=$this->request->getFile('curpAR');
			$ConstanciaFiscal=$this->request->getFile('ConstanciaFiscal');
			$AperturaEstablecimiento=$this->request->getFile('AperturaEstablecimiento');
			$LicMunicipal=$this->request->getFile('LicMunicipal');
			$ComprobanteDomicilio=$this->request->getFile('ComprobanteDomicilio');
			$PoderAbogado=$this->request->getFile('PoderAbogado');
			$RegRep=$this->request->getFile('RegRep');


			$logoCliente_nom=$_POST['logoCliente_nom'];
			$logoCliente_ext=$_POST['logoCliente_ext'];


			$ideOficial_nom=$_POST['ideOficial_nom'];
			$curpAR_nom=$_POST['curpAR_nom'];
			$ConstanciaFiscal_nom=$_POST['ConstanciaFiscal_nom'];
			$AperturaEstablecimiento_nom=$_POST['AperturaEstablecimiento_nom'];
			$LicMunicipal_nom=$_POST['LicMunicipal_nom'];
			$ComprobanteDomicilio_nom=$_POST['ComprobanteDomicilio_nom'];
			$PoderAbogado_nom=$_POST['PoderAbogado_nom'];
			$RegRep_nom=$_POST['RegRep_nom'];
			$ideOficial_ext=$_POST['ideOficial_ext'];
			$curpAR_ext=$_POST['curpAR_ext'];
			$ConstanciaFiscal_ext=$_POST['ConstanciaFiscal_ext'];
			$AperturaEstablecimiento_ext=$_POST['AperturaEstablecimiento_ext'];
			$LicMunicipal_ext=$_POST['LicMunicipal_ext'];
			$ComprobanteDomicilio_ext=$_POST['ComprobanteDomicilio_ext'];
			$PoderAbogado_ext=$_POST['PoderAbogado_ext'];
			$RegRep_ext=$_POST['RegRep_ext'];






			if ($logoCliente != ""){

				$logoCliente=$this->request->getFile('logoCliente');
				
				$archivo_name=$_FILES['logoCliente']['name'];
				
				$extension = explode(".",$archivo_name);
				$num = count($extension)-1;
				
				
				
				
				
				
					//borrar archivo en caso de que ya exista 
					$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-logoCliente.$extension[$num]";
					
				
					if (file_exists($rutaDoc)){
				
						unlink($rutaDoc);
						$carpeta="./dist/img/cliente/expediente/";
						if (!file_exists($carpeta)){
				
							mkdir($carpeta,077,true);
						}
				
					}
					
												
				
				
				$logoCliente->move("./dist/img/cliente/expediente/", "$folioLitigante-logoCliente.$extension[$num]");
				
				
				
				
				
				$logoCliente_nom="$folioLitigante-logoCliente.$extension[$num]";
				$logoCliente_ext="$extension[$num]";
				
				
				
				
				
							//----------------------------------------------insertamos 
				
				}







			if ($ideOficial != ""){

				$ideOficial=$this->request->getFile('ideOficial');
				
				$archivo_name=$_FILES['ideOficial']['name'];
				
				$extension = explode(".",$archivo_name);
				$num = count($extension)-1;
				
				
				
				
				
				
					//borrar archivo en caso de que ya exista 
					$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-ideOficial.$extension[$num]";
					
				
					if (file_exists($rutaDoc)){
				
						unlink($rutaDoc);
						$carpeta="./dist/img/cliente/expediente/";
						if (!file_exists($carpeta)){
				
							mkdir($carpeta,077,true);
						}
				
					}
					
												
				
				
				$ideOficial->move("./dist/img/cliente/expediente/", "$folioLitigante-ideOficial.$extension[$num]");
				
				
				
				
				
				$ideOficial_nom="$folioLitigante-ideOficial.$extension[$num]";
				$ideOficial_ext="$extension[$num]";
				
				
				
				
				
							//----------------------------------------------insertamos 
				
				}


				if ($curpAR != ""){

					$curpAR=$this->request->getFile('curpAR');
					
					$archivo_name=$_FILES['curpAR']['name'];
					
					$extension = explode(".",$archivo_name);
					$num = count($extension)-1;
					
					
					
					
					
					
						//borrar archivo en caso de que ya exista 
						$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-curpAR.$extension[$num]";
						
					
						if (file_exists($rutaDoc)){
					
							unlink($rutaDoc);
							$carpeta="./dist/img/cliente/expediente/";
							if (!file_exists($carpeta)){
					
								mkdir($carpeta,077,true);
							}
					
						}
						
													
					
					
					$curpAR->move("./dist/img/cliente/expediente/", "$folioLitigante-curpAR.$extension[$num]");
					
					
					
					
					
					$curpAR_nom="$folioLitigante-curpAR.$extension[$num]";
					$curpAR_ext="$extension[$num]";
					
					
					
					
					
								//----------------------------------------------insertamos 
					
					}





					if ($ConstanciaFiscal != ""){

						$ConstanciaFiscal=$this->request->getFile('ConstanciaFiscal');
						
						$archivo_name=$_FILES['ConstanciaFiscal']['name'];
						
						$extension = explode(".",$archivo_name);
						$num = count($extension)-1;
						
						
						
						
						
						
							//borrar archivo en caso de que ya exista 
							$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-ConstanciaFiscal.$extension[$num]";
							
						
							if (file_exists($rutaDoc)){
						
								unlink($rutaDoc);
								$carpeta="./dist/img/cliente/expediente/";
								if (!file_exists($carpeta)){
						
									mkdir($carpeta,077,true);
								}
						
							}
							
														
						
						
						$ConstanciaFiscal->move("./dist/img/cliente/expediente/", "$folioLitigante-ConstanciaFiscal.$extension[$num]");
						
						
						
						
						
						$ConstanciaFiscal_nom="$folioLitigante-ConstanciaFiscal.$extension[$num]";
						$ConstanciaFiscal_ext="$extension[$num]";
						
						
						
						
						
									//----------------------------------------------insertamos 
						
						}


						if ($AperturaEstablecimiento != ""){

							$AperturaEstablecimiento=$this->request->getFile('AperturaEstablecimiento');
							
							$archivo_name=$_FILES['AperturaEstablecimiento']['name'];
							
							$extension = explode(".",$archivo_name);
							$num = count($extension)-1;
							
							
							
							
							
							
								//borrar archivo en caso de que ya exista 
								$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-AperturaEstablecimiento.$extension[$num]";
								
							
								if (file_exists($rutaDoc)){
							
									unlink($rutaDoc);
									$carpeta="./dist/img/cliente/expediente/";
									if (!file_exists($carpeta)){
							
										mkdir($carpeta,077,true);
									}
							
								}
								
															
							
							
							$AperturaEstablecimiento->move("./dist/img/cliente/expediente/", "$folioLitigante-AperturaEstablecimiento.$extension[$num]");
							
							
							
							
							
							$AperturaEstablecimiento_nom="$folioLitigante-AperturaEstablecimiento.$extension[$num]";
							$AperturaEstablecimiento_ext="$extension[$num]";
							
							
							
							
							
										//----------------------------------------------insertamos 
							
							}




							if ($LicMunicipal != ""){

								$LicMunicipal=$this->request->getFile('LicMunicipal');
								
								$archivo_name=$_FILES['LicMunicipal']['name'];
								
								$extension = explode(".",$archivo_name);
								$num = count($extension)-1;
								
								
								
								
								
								
									//borrar archivo en caso de que ya exista 
									$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-LicMunicipal.$extension[$num]";
									
								
									if (file_exists($rutaDoc)){
								
										unlink($rutaDoc);
										$carpeta="./dist/img/cliente/expediente/";
										if (!file_exists($carpeta)){
								
											mkdir($carpeta,077,true);
										}
								
									}
									
																
								
								
								$LicMunicipal->move("./dist/img/cliente/expediente/", "$folioLitigante-LicMunicipal.$extension[$num]");
								
								
								
								
								
								$LicMunicipal_nom="$folioLitigante-LicMunicipal.$extension[$num]";
								$LicMunicipal_ext="$extension[$num]";
								
								
								
								
								
											//----------------------------------------------insertamos 
								
								}



								if ($ComprobanteDomicilio != ""){

									$ComprobanteDomicilio=$this->request->getFile('ComprobanteDomicilio');
									
									$archivo_name=$_FILES['ComprobanteDomicilio']['name'];
									
									$extension = explode(".",$archivo_name);
									$num = count($extension)-1;
									
									
									
									
									
									
										//borrar archivo en caso de que ya exista 
										$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-ComprobanteDomicilio.$extension[$num]";
										
									
										if (file_exists($rutaDoc)){
									
											unlink($rutaDoc);
											$carpeta="./dist/img/cliente/expediente/";
											if (!file_exists($carpeta)){
									
												mkdir($carpeta,077,true);
											}
									
										}
										
																	
									
									
									$ComprobanteDomicilio->move("./dist/img/cliente/expediente/", "$folioLitigante-ComprobanteDomicilio.$extension[$num]");
									
									
									
									
									
									$ComprobanteDomicilio_nom="$folioLitigante-ComprobanteDomicilio.$extension[$num]";
									$ComprobanteDomicilio_ext="$extension[$num]";
									
									
									
									
									
												//----------------------------------------------insertamos 
									
									}





									if ($PoderAbogado != ""){

										$PoderAbogado=$this->request->getFile('PoderAbogado');
										
										$archivo_name=$_FILES['PoderAbogado']['name'];
										
										$extension = explode(".",$archivo_name);
										$num = count($extension)-1;
										
										
										
										
										
										
											//borrar archivo en caso de que ya exista 
											$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-PoderAbogado.$extension[$num]";
											
										
											if (file_exists($rutaDoc)){
										
												unlink($rutaDoc);
												$carpeta="./dist/img/cliente/expediente/";
												if (!file_exists($carpeta)){
										
													mkdir($carpeta,077,true);
												}
										
											}
											
																		
										
										
										$PoderAbogado->move("./dist/img/cliente/expediente/", "$folioLitigante-PoderAbogado.$extension[$num]");
										
										
										
										
										
										$PoderAbogado_nom="$folioLitigante-PoderAbogado.$extension[$num]";
										$PoderAbogado_ext="$extension[$num]";
										
										
										
										
										
													//----------------------------------------------insertamos 
										
										}


										if ($RegRep != ""){

											$RegRep=$this->request->getFile('RegRep');
											
											$archivo_name=$_FILES['RegRep']['name'];
											
											$extension = explode(".",$archivo_name);
											$num = count($extension)-1;
											
											
											
											
											
											
												//borrar archivo en caso de que ya exista 
												$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-RegRep.$extension[$num]";
												
											
												if (file_exists($rutaDoc)){
											
													unlink($rutaDoc);
													$carpeta="./dist/img/cliente/expediente/";
													if (!file_exists($carpeta)){
											
														mkdir($carpeta,077,true);
													}
											
												}
												
																			
											
											
											$RegRep->move("./dist/img/cliente/expediente/", "$folioLitigante-RegRep.$extension[$num]");
											
											
											
											
											
											$RegRep_nom="$folioLitigante-RegRep.$extension[$num]";
											$RegRep_ext="$extension[$num]";
											
											
											
											
											
														//----------------------------------------------insertamos 
											
											}
	












		$id=$this->request->getPost('id');
	
		$this->clientesj->update($id,['nombre'=> $this->request->getPost('nombre'),
								'id_contacto'=>$this->request->getPost('id_contacto'),
								
								'calle'=>$this->request->getPost('calle'),
								'cp'=>$this->request->getPost('cp'),
								'colonia'=>$this->request->getPost('colonia'),
								'ciudad'=>$this->request->getPost('ciudad'),
								'id_estado'=>$this->request->getPost('estado'),
								
								'telefono'=>$b,
								'celular'=>$d,
								'email'=>$this->request->getPost('email'),
								'rfc'=>$this->request->getPost('rfc'),
								'registroPatronal'=>$this->request->getPost('regPatronal'),
								'curp'=>$this->request->getPost('curp'),
								'comentarios'=>$this->request->getPost('comentarios'),
								'moral_fisica'=>$this->request->getPost('tipo'),

								//nombres de documentos y extensiones
								'logoCliente'=>$logoCliente_nom,
								'logoCliente_ext'=>$logoCliente_ext, 

								'ideOficial_nom'=>$ideOficial_nom,
								'ideOficial_ext'=>$ideOficial_ext,
								'curpAR_nom'=>$curpAR_nom,
								'curpAR_ext'=>$curpAR_ext,
								'ConstanciaFiscal_nom'=>$ConstanciaFiscal_nom,
								'ConstanciaFiscal_ext'=>$ConstanciaFiscal_ext,
								'AperturaEstablecimiento_nom'=>$AperturaEstablecimiento_nom,
								'AperturaEstablecimiento_ext'=>$AperturaEstablecimiento_ext,
								'LicMunicipal_nom'=>$LicMunicipal_nom,
								'LicMunicipal_ext'=>$LicMunicipal_ext,
								'ComprobanteDomicilio_nom'=>$ComprobanteDomicilio_nom,
								'ComprobanteDomicilio_ext'=>$ComprobanteDomicilio_ext,
								'PoderAbogado_nom'=>$PoderAbogado_nom,
								'PoderAbogado_ext'=>$PoderAbogado_ext,
								'RegRep_nom'=>$RegRep_nom,
								'RegRep_ext'=>$RegRep_ext,



								]);
		
					
	return redirect()->to(base_url().'/clientesj');
		
	}
}






//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function actualizar(){
        if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		if($this->request->getMethod()=="post"){
				


			$a=$_POST['telefono'];
			$b = str_replace('-', '', $a );
			$c=$_POST['celular'];
			$d= str_replace('-', '', $c );

			$this->clientesj->update($this->request->getPost('id'),
								   ['nombre'=> $this->request->getPost('nombre'),
									'id_contacto'=>$this->request->getPost('id_contacto'),
									'calle'=>$this->request->getPost('calle'),
									'cp'=>$this->request->getPost('cp'),
									'colonia'=>$this->request->getPost('colonia'),
									'ciudad'=>$this->request->getPost('ciudad'),
									'id_estado'=>$this->request->getPost('estado'),
									'id_pais'=>$this->request->getPost('pais'),
									'telefono'=>$b,
									'celular'=>$d,
									'email'=>$this->request->getPost('email'),
									'rfc'=>$this->request->getPost('rfc'),
									'curp'=>$this->request->getPost('curp'),
									'comentarios'=>$this->request->getPost('comentarios')
									]);
		
		return redirect()->to(base_url().'/clientesj');
		}else{
			
			return $this->editar($this->request->getPost('id'),$this->validator);
		}
		
        
		
	}
	
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------	
	public function eliminar($id){
        
        
        if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        
         $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'ClientesEliminar');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/clientes');
           
           
            
        }
        
		
		
		$this->clientesj->update($id,['activo'=> 0]);
		return redirect()->to(base_url().'/clientesj');
		
		
        
		
	}
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function eliminados($activo=0){
        if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
         $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'ClientesEliminados');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/clientes');
           
           
            
        }
		$clientes=$this->clientesj->where('activo',$activo)->findAll();
		$data=['titulo'=>'Clientes eliminadas','datos'=>$clientes];
		
		
        echo view('header');
		echo view('clientesj/eliminadas', $data);
		echo view('footer');
		
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
		public function reingresar($id){
            if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		
		
		$this->clientesj->update($id,['activo'=> 1]);
		return redirect()->to(base_url().'/clientesj');
		
		
        
		
	}
	
//-------------------------------------------------------------------------------------------------------------------------------------------------------------- 
    public function autocompleteData(){
        if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		$returnData=array();
		
		$valor=$this->request->getGet('term');
        $clientes=$this->clientes->like('nombre',$valor)->where('activo', 1)->findAll();
		
        if (!empty($clientes)){
            
            foreach($clientes as $row ){
                $data['id']=$row['id'];
                $data['value']=$row['nombre'];
                
                array_push($returnData,$data);
            }
        }
        
        echo json_encode($returnData);
		
	}





































//moral----------------------------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
public function insertarMorall(){
	if (!isset($this->session->id_usuario)){
		return redirect()->to(base_url());
	}
	
		if($this->request->getMethod()=="post"){



			$folioLitigante=$_POST['folioLitiganteM'];
	
			$a=$_POST['telefonoM'];
			$b = str_replace('-', '', $a );
			$c=$_POST['celularM'];
			$d= str_replace('-', '', $c );

			$logoCliente=$this->request->getFile('logoClienteM');
			$ActaConstitutiva=$this->request->getFile('ActaConstitutiva');

			$PoderNotarial=$this->request->getFile('PoderNotarial');

			$AperturaEstablecimientoM=$this->request->getFile('AperturaEstablecimientoM');

			$ConstanciaSituacionfiscalM=$this->request->getFile('ConstanciaSituacionfiscalM');

			$altaPatronalM=$this->request->getFile('altaPatronalM');

			$LicMunicipalM=$this->request->getFile('LicMunicipalM');

			$ComprobanteDomicilioM=$this->request->getFile('ComprobanteDomicilioM');

			$PoderAbogadoM=$this->request->getFile('PoderAbogadoM');

			$RegRepM=$this->request->getFile('RegRepM');

			$identificacionRepresentaLegal=$this->request->getFile('identificacionRepresentaLegal');

			$identificacionApoderado=$this->request->getFile('identificacionApoderado');

			$curpRepresenta=$this->request->getFile('curpRepresenta');
			$rfcRepresenta=$this->request->getFile('rfcRepresenta');


			$logoCliente_nom=0;
			$ActaConstitutiva_nom=0;
			$PoderNotarial_nom=0;
			$AperturaEstablecimiento_nom=0;
			$ConstanciaFiscal_nom=0;
			$altaPatronalM_nom=0;
			$LicMunicipal_nom=0;
			$ComprobanteDomicilio_nom=0;
			$PoderAbogado_nom=0;
			$RegRep_nom=0;
			$identificacionRepresentaLegal_nom=0;
			$identificacionApoderado_nom=0;
			$rfcRepresenta_nom=0;
			$curpRepresenta_nom=0;




			$logoCliente_ext="";
			$ActaConstitutiva_ext="";
			$PoderNotarial_ext="";
			$AperturaEstablecimiento_ext="";
			$ConstanciaFiscal_ext="";
			$altaPatronalM_ext="";
			$LicMunicipal_ext="";
			$ComprobanteDomicilio_ext="";
			$PoderAbogado_ext="";
			$RegRep_ext="";
			$identificacionRepresentaLegal_ext="";
			$identificacionApoderado_ext="";
			$rfcRepresenta_ext="";
			$curpRepresenta_ext="";




			










			if ($logoCliente != ""){

				$logoCliente=$this->request->getFile('logoClienteM');
				
				$archivo_name=$_FILES['logoClienteM']['name'];
				
				$extension = explode(".",$archivo_name);
				$num = count($extension)-1;
				
				
				
				
				
				
					//borrar archivo en caso de que ya exista 
					$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-logoCliente.$extension[$num]";
					
				
					if (file_exists($rutaDoc)){
				
						unlink($rutaDoc);
						$carpeta="./dist/img/cliente/expediente/";
						if (!file_exists($carpeta)){
				
							mkdir($carpeta,077,true);
						}
				
					}
					
												
				
				
				$logoCliente->move("./dist/img/cliente/expediente/", "$folioLitigante-logoCliente.$extension[$num]");
				
				
				
				
				
				$logoCliente_nom="$folioLitigante-logoCliente.$extension[$num]";
				$logoCliente_ext="$extension[$num]";
				
				
				
				
				
							//----------------------------------------------insertamos 
				
				}









			




			if ($ActaConstitutiva != ""){

				$ActaConstitutiva=$this->request->getFile('ActaConstitutiva');
				
				$archivo_name=$_FILES['ActaConstitutiva']['name'];
				
				$extension = explode(".",$archivo_name);
				$num = count($extension)-1;
				
				
				
				
				
				
					//borrar archivo en caso de que ya exista 
					$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-ActaConstitutiva.$extension[$num]";
					
				
					if (file_exists($rutaDoc)){
				
						unlink($rutaDoc);
						$carpeta="./dist/img/cliente/expediente/";
						if (!file_exists($carpeta)){
				
							mkdir($carpeta,077,true);
						}
				
					}
					
												
				
				
				$ActaConstitutiva->move("./dist/img/cliente/expediente/", "$folioLitigante-ActaConstitutiva.$extension[$num]");
				
				
				
				
				
				$ActaConstitutiva_nom="$folioLitigante-ActaConstitutiva.$extension[$num]";
				$ActaConstitutiva_ext="$extension[$num]";
				
				
				
				
				
							//----------------------------------------------insertamos 
				
				}




			if ($PoderNotarial != ""){

				$PoderNotarial=$this->request->getFile('PoderNotarial');
				
				$archivo_name=$_FILES['PoderNotarial']['name'];
				
				$extension = explode(".",$archivo_name);
				$num = count($extension)-1;
				
				
				
				
				
				
					//borrar archivo en caso de que ya exista 
					$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-PoderNotarial.$extension[$num]";
					
				
					if (file_exists($rutaDoc)){
				
						unlink($rutaDoc);
						$carpeta="./dist/img/cliente/expediente/";
						if (!file_exists($carpeta)){
				
							mkdir($carpeta,077,true);
						}
				
					}
					
												
				
				
				$PoderNotarial->move("./dist/img/cliente/expediente/", "$folioLitigante-PoderNotarial.$extension[$num]");
				
				
				
				
				
				$PoderNotarial_nom="$folioLitigante-PoderNotarial.$extension[$num]";
				$PoderNotarial_ext="$extension[$num]";
				
				
				
				
				
							//----------------------------------------------insertamos 
				
				}


				if ($AperturaEstablecimientoM != ""){

					$AperturaEstablecimientoM=$this->request->getFile('AperturaEstablecimientoM');
					
					$archivo_name=$_FILES['AperturaEstablecimientoM']['name'];
					
					$extension = explode(".",$archivo_name);
					$num = count($extension)-1;
					
					
					
					
					
					
						//borrar archivo en caso de que ya exista 
						$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-AperturaEstablecimientoM.$extension[$num]";
						
					
						if (file_exists($rutaDoc)){
					
							unlink($rutaDoc);
							$carpeta="./dist/img/cliente/expediente/";
							if (!file_exists($carpeta)){
					
								mkdir($carpeta,077,true);
							}
					
						}
						
													
					
					
					$AperturaEstablecimientoM->move("./dist/img/cliente/expediente/", "$folioLitigante-AperturaEstablecimientoM.$extension[$num]");
					
					
					
					
					
					$AperturaEstablecimiento_nom="$folioLitigante-AperturaEstablecimientoM.$extension[$num]";
					$AperturaEstablecimiento_ext="$extension[$num]";
					
					
					
					
					
								//----------------------------------------------insertamos 
					
					}





					if ($ConstanciaSituacionfiscalM != ""){

						$ConstanciaSituacionfiscalM=$this->request->getFile('ConstanciaSituacionfiscalM');
						
						$archivo_name=$_FILES['ConstanciaSituacionfiscalM']['name'];
						
						$extension = explode(".",$archivo_name);
						$num = count($extension)-1;
						
						
						
						
						
						
							//borrar archivo en caso de que ya exista 
							$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-ConstanciaSituacionfiscalM.$extension[$num]";
							
						
							if (file_exists($rutaDoc)){
						
								unlink($rutaDoc);
								$carpeta="./dist/img/cliente/expediente/";
								if (!file_exists($carpeta)){
						
									mkdir($carpeta,077,true);
								}
						
							}
							
														
						
						
						$ConstanciaSituacionfiscalM->move("./dist/img/cliente/expediente/", "$folioLitigante-ConstanciaSituacionfiscalM.$extension[$num]");
						
						
						
						
						
						$ConstanciaFiscal_nom="$folioLitigante-ConstanciaSituacionfiscalM.$extension[$num]";
						$ConstanciaFiscal_ext="$extension[$num]";
						
						
						
						
						
									//----------------------------------------------insertamos 
						
						}


						if ($altaPatronalM != ""){

							$altaPatronalM=$this->request->getFile('altaPatronalM');
							
							$archivo_name=$_FILES['altaPatronalM']['name'];
							
							$extension = explode(".",$archivo_name);
							$num = count($extension)-1;
							
							
							
							
							
							
								//borrar archivo en caso de que ya exista 
								$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-altaPatronalM.$extension[$num]";
								
							
								if (file_exists($rutaDoc)){
							
									unlink($rutaDoc);
									$carpeta="./dist/img/cliente/expediente/";
									if (!file_exists($carpeta)){
							
										mkdir($carpeta,077,true);
									}
							
								}
								
															
							
							
							$altaPatronalM->move("./dist/img/cliente/expediente/", "$folioLitigante-altaPatronalM.$extension[$num]");
							
							
							
							
							
							$altaPatronalM_nom="$folioLitigante-altaPatronalM.$extension[$num]";
							$altaPatronalM_ext="$extension[$num]";
							
							
							
							
							
										//----------------------------------------------insertamos 
							
							}




							if ($LicMunicipalM != ""){

								$LicMunicipalM=$this->request->getFile('LicMunicipalM');
								
								$archivo_name=$_FILES['LicMunicipalM']['name'];
								
								$extension = explode(".",$archivo_name);
								$num = count($extension)-1;
								
								
								
								
								
								
									//borrar archivo en caso de que ya exista 
									$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-LicMunicipalM.$extension[$num]";
									
								
									if (file_exists($rutaDoc)){
								
										unlink($rutaDoc);
										$carpeta="./dist/img/cliente/expediente/";
										if (!file_exists($carpeta)){
								
											mkdir($carpeta,077,true);
										}
								
									}
									
																
								
								
								$LicMunicipalM->move("./dist/img/cliente/expediente/", "$folioLitigante-LicMunicipalM.$extension[$num]");
								
								
								
								
								
								$LicMunicipal_nom="$folioLitigante-LicMunicipalM.$extension[$num]";
								$LicMunicipal_ext="$extension[$num]";
								
								
								
								
								
											//----------------------------------------------insertamos 
								
								}



								if ($ComprobanteDomicilioM != ""){

									$ComprobanteDomicilioM=$this->request->getFile('ComprobanteDomicilioM');
									
									$archivo_name=$_FILES['ComprobanteDomicilioM']['name'];
									
									$extension = explode(".",$archivo_name);
									$num = count($extension)-1;
									
									
									
									
									
									
										//borrar archivo en caso de que ya exista 
										$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-ComprobanteDomicilioM.$extension[$num]";
										
									
										if (file_exists($rutaDoc)){
									
											unlink($rutaDoc);
											$carpeta="./dist/img/cliente/expediente/";
											if (!file_exists($carpeta)){
									
												mkdir($carpeta,077,true);
											}
									
										}
										
																	
									
									
									$ComprobanteDomicilioM->move("./dist/img/cliente/expediente/", "$folioLitigante-ComprobanteDomicilioM.$extension[$num]");
									
									
									
									
									
									$ComprobanteDomicilio_nom="$folioLitigante-ComprobanteDomicilioM.$extension[$num]";
									$ComprobanteDomicilio_ext="$extension[$num]";
									
									
									
									
									
												//----------------------------------------------insertamos 
									
									}





									if ($PoderAbogadoM != ""){

										$PoderAbogadoM=$this->request->getFile('PoderAbogadoM');
										
										$archivo_name=$_FILES['PoderAbogadoM']['name'];
										
										$extension = explode(".",$archivo_name);
										$num = count($extension)-1;
										
										
										
										
										
										
											//borrar archivo en caso de que ya exista 
											$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-PoderAbogadoM.$extension[$num]";
											
										
											if (file_exists($rutaDoc)){
										
												unlink($rutaDoc);
												$carpeta="./dist/img/cliente/expediente/";
												if (!file_exists($carpeta)){
										
													mkdir($carpeta,077,true);
												}
										
											}
											
																		
										
										
										$PoderAbogadoM->move("./dist/img/cliente/expediente/", "$folioLitigante-PoderAbogadoM.$extension[$num]");
										
										
										
										
										
										$PoderAbogado_nom="$folioLitigante-PoderAbogadoM.$extension[$num]";
										$PoderAbogado_ext="$extension[$num]";
										
										
										
										
										
													//----------------------------------------------insertamos 
										
										}


										if ($RegRepM != ""){

											$RegRepM=$this->request->getFile('RegRepM');
											
											$archivo_name=$_FILES['RegRepM']['name'];
											
											$extension = explode(".",$archivo_name);
											$num = count($extension)-1;
											
											
											
											
											
											
												//borrar archivo en caso de que ya exista 
												$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-RegRepM.$extension[$num]";
												
											
												if (file_exists($rutaDoc)){
											
													unlink($rutaDoc);
													$carpeta="./dist/img/cliente/expediente/";
													if (!file_exists($carpeta)){
											
														mkdir($carpeta,077,true);
													}
											
												}
												
																			
											
											
											$RegRepM->move("./dist/img/cliente/expediente/", "$folioLitigante-RegRepM.$extension[$num]");
											
											
											
											
											
											$RegRep_nom="$folioLitigante-RegRepM.$extension[$num]";
											$RegRep_ext="$extension[$num]";
											
											
											
											
											
														//----------------------------------------------insertamos 
											
											}




											if ($identificacionRepresentaLegal != ""){

												$identificacionRepresentaLegal=$this->request->getFile('identificacionRepresentaLegal');
												
												$archivo_name=$_FILES['identificacionRepresentaLegal']['name'];
												
												$extension = explode(".",$archivo_name);
												$num = count($extension)-1;
												
												
												
												
												
												
													//borrar archivo en caso de que ya exista 
													$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-identificacionRepresentaLegal.$extension[$num]";
													
												
													if (file_exists($rutaDoc)){
												
														unlink($rutaDoc);
														$carpeta="./dist/img/cliente/expediente/";
														if (!file_exists($carpeta)){
												
															mkdir($carpeta,077,true);
														}
												
													}
													
																				
												
												
												$identificacionRepresentaLegal->move("./dist/img/cliente/expediente/", "$folioLitigante-identificacionRepresentaLegal.$extension[$num]");
												
												
												
												
												
												$identificacionRepresentaLegal_nom="$folioLitigante-identificacionRepresentaLegal.$extension[$num]";
												$identificacionRepresentaLegal_ext="$extension[$num]";
												
												
												
												
												
															//----------------------------------------------insertamos 
												
												}
	

												if ($identificacionApoderado != ""){

													$identificacionApoderado=$this->request->getFile('identificacionApoderado');
													
													$archivo_name=$_FILES['identificacionApoderado']['name'];
													
													$extension = explode(".",$archivo_name);
													$num = count($extension)-1;
													
													
													
													
													
													
														//borrar archivo en caso de que ya exista 
														$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-identificacionApoderado.$extension[$num]";
														
													
														if (file_exists($rutaDoc)){
													
															unlink($rutaDoc);
															$carpeta="./dist/img/cliente/expediente/";
															if (!file_exists($carpeta)){
													
																mkdir($carpeta,077,true);
															}
													
														}
														
																					
													
													
													$identificacionApoderado->move("./dist/img/cliente/expediente/", "$folioLitigante-identificacionApoderado.$extension[$num]");
													
													
													
													
													
													$identificacionApoderado_nom="$folioLitigante-identificacionApoderado.$extension[$num]";
													$identificacionApoderado_ext="$extension[$num]";
													
													
													
													
													
																//----------------------------------------------insertamos 
													
													}
		

													
												if ($rfcRepresenta != ""){

													$rfcRepresenta=$this->request->getFile('rfcRepresenta');
													
													$archivo_name=$_FILES['rfcRepresenta']['name'];
													
													$extension = explode(".",$archivo_name);
													$num = count($extension)-1;
													
													
													
													
													
													
														//borrar archivo en caso de que ya exista 
														$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-rfcRepresenta.$extension[$num]";
														
													
														if (file_exists($rutaDoc)){
													
															unlink($rutaDoc);
															$carpeta="./dist/img/cliente/expediente/";
															if (!file_exists($carpeta)){
													
																mkdir($carpeta,077,true);
															}
													
														}
														
																					
													
													
													$rfcRepresenta->move("./dist/img/cliente/expediente/", "$folioLitigante-rfcRepresenta.$extension[$num]");
													
													
													
													
													
													$rfcRepresenta_nom="$folioLitigante-rfcRepresenta.$extension[$num]";
													$rfcRepresenta_ext="$extension[$num]";
													
													
													
													
													
																//----------------------------------------------insertamos 
													
													}






														if ($curpRepresenta != ""){

														$curpRepresenta=$this->request->getFile('curpRepresenta');
														
														$archivo_name=$_FILES['curpRepresenta']['name'];
														
														$extension = explode(".",$archivo_name);
														$num = count($extension)-1;
														
														
														
														
														
														
															//borrar archivo en caso de que ya exista 
															$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-curpRepresenta.$extension[$num]";
															
														
															if (file_exists($rutaDoc)){
														
																unlink($rutaDoc);
																$carpeta="./dist/img/cliente/expediente/";
																if (!file_exists($carpeta)){
														
																	mkdir($carpeta,077,true);
																}
														
															}
															
																						
														
														
														$curpRepresenta->move("./dist/img/cliente/expediente/", "$folioLitigante-curpRepresenta.$extension[$num]");
														
														
														
														
														
														$curpRepresenta_nom="$folioLitigante-curpRepresenta.$extension[$num]";
														$curpRepresenta_ext="$extension[$num]";
														
														
														
														
														
																	//----------------------------------------------insertamos 
														
														}





														
														if (!isset($_POST['calleM2'])){
															$calle2="";
														}else {

															$calle2=$_POST['calleM2'];
														}

														if (!isset($_POST['calleM3'])){
															$calle3="";
														}else {

															$calle3=$_POST['calleM3'];
														}
														if (!isset($_POST['calleM4'])){
															$calle4="";
														}else {

															$calle4=$_POST['calleM4'];
														}
														if (!isset($_POST['calleM5'])){
															$calle5="";
														}else {

															$calle5=$_POST['calleM5'];
														}

														if (!isset($_POST['calleM6'])){
															$calle6="";
														}else {

															$calle6=$_POST['calleM6'];
														}

														if (!isset($_POST['calleM7'])){
															$calle7="";
														}else {

															$calle7=$_POST['calleM7'];
														}

														if (!isset($_POST['calleM8'])){
															$calle8="";
														}else {

															$calle8=$_POST['calleM8'];
														}

														if (!isset($_POST['calleM9'])){
															$calle9="";
														}else {

															$calle9=$_POST['calleM9'];
														}

														if (!isset($_POST['calleM10'])){
															$calle10="";
														}else {

															$calle10=$_POST['calleM10'];
														}

														if (!isset($_POST['calleM11'])){
															$calle11="";
														}else {

															$calle11=$_POST['calleM11'];
														}

														if (!isset($_POST['calleM12'])){
															$calle12="";
														}else {

															$calle12=$_POST['calleM12'];
														}

														if (!isset($_POST['calleM13'])){
															$calle13="";
														}else {

															$calle13=$_POST['calleM13'];
														}


														if (!isset($_POST['calleM14'])){
															$calle14="";
														}else {

															$calle14=$_POST['calleM14'];
														}

														if (!isset($_POST['calleM15'])){
															$calle15="";
														}else {

															$calle15=$_POST['calleM15'];
														}


														//-------------------------------------------------------
														if (!isset($_POST['cpM2'])){
															$cp2="";
														}else {

															$cp2=$_POST['cpM2'];
														}

														if (!isset($_POST['cpM3'])){
															$cp3="";
														}else {

															$cp3=$_POST['cpM3'];
														}

														if (!isset($_POST['cpM4'])){
															$cp4="";
														}else {

															$cp4=$_POST['cpM4'];
														}

														if (!isset($_POST['cpM5'])){
															$cp5="";
														}else {

															$cp5=$_POST['cpM5'];
														}

														if (!isset($_POST['cpM6'])){
															$cp6="";
														}else {

															$cp6=$_POST['cpM6'];
														}

														if (!isset($_POST['cpM7'])){
															$cp7="";
														}else {

															$cp7=$_POST['cpM7'];
														}

														if (!isset($_POST['cpM8'])){
															$cp8="";
														}else {

															$cp8=$_POST['cpM8'];
														}


														if (!isset($_POST['cpM9'])){
															$cp9="";
														}else {

															$cp9=$_POST['cpM9'];
														}

														if (!isset($_POST['cpM10'])){
															$cp10="";
														}else {

															$cp10=$_POST['cpM10'];
														}

														if (!isset($_POST['cpM11'])){
															$cp11="";
														}else {

															$cp11=$_POST['cpM11'];
														}

														if (!isset($_POST['cpM12'])){
															$cp12="";
														}else {

															$cp12=$_POST['cpM12'];
														}

														if (!isset($_POST['cpM13'])){
															$cp13="";
														}else {

															$cp13=$_POST['cpM13'];
														}

														if (!isset($_POST['cpM14'])){
															$cp14="";
														}else {

															$cp14=$_POST['cpM14'];
														}

														if (!isset($_POST['cpM15'])){
															$cp15="";
														}else {

															$cp15=$_POST['cpM15'];
														}
														//-------------------------------------------------------

														if (!isset($_POST['coloniaM2'])){
															$colonia2="";
														}else {

															$colonia2=$_POST['coloniaM2'];
														}

														if (!isset($_POST['coloniaM3'])){
															$colonia3="";
														}else {

															$colonia3=$_POST['coloniaM3'];
														}

														if (!isset($_POST['coloniaM4'])){
															$colonia4="";
														}else {

															$colonia4=$_POST['coloniaM4'];
														}

														if (!isset($_POST['coloniaM5'])){
															$colonia5="";
														}else {

															$colonia5=$_POST['coloniaM5'];
														}

														if (!isset($_POST['coloniaM6'])){
															$colonia6="";
														}else {

															$colonia6=$_POST['coloniaM6'];
														}

														if (!isset($_POST['coloniaM7'])){
															$colonia7="";
														}else {

															$colonia7=$_POST['coloniaM7'];
														}

														if (!isset($_POST['coloniaM8'])){
															$colonia8="";
														}else {

															$colonia8=$_POST['coloniaM8'];
														}

														if (!isset($_POST['coloniaM9'])){
															$colonia9="";
														}else {

															$colonia9=$_POST['coloniaM9'];
														}

														if (!isset($_POST['coloniaM10'])){
															$colonia10="";
														}else {

															$colonia10=$_POST['coloniaM10'];
														}

														if (!isset($_POST['coloniaM11'])){
															$colonia11="";
														}else {

															$colonia11=$_POST['coloniaM11'];
														}

														if (!isset($_POST['coloniaM12'])){
															$colonia12="";
														}else {

															$colonia12=$_POST['coloniaM12'];
														}

														if (!isset($_POST['coloniaM13'])){
															$colonia13="";
														}else {

															$colonia13=$_POST['coloniaM13'];
														}

														
														if (!isset($_POST['coloniaM14'])){
															$colonia14="";
														}else {

															$colonia14=$_POST['coloniaM14'];
														}

														
														if (!isset($_POST['coloniaM15'])){
															$colonia15="";
														}else {

															$colonia15=$_POST['coloniaM15'];
														}
														//-------------------------------------------------------
														if (!isset($_POST['ciudadM2'])){
															$ciudad2="";
														}else {

															$ciudad2=$_POST['ciudadM2'];
														}

														if (!isset($_POST['ciudadM3'])){
															$ciudad3="";
														}else {

															$ciudad3=$_POST['ciudadM3'];
														}

														if (!isset($_POST['ciudadM4'])){
															$ciudad4="";
														}else {

															$ciudad4=$_POST['ciudadM4'];
														}

														if (!isset($_POST['ciudadM5'])){
															$ciudad5="";
														}else {

															$ciudad5=$_POST['ciudadM5'];
														}

														if (!isset($_POST['ciudadM6'])){
															$ciudad6="";
														}else {

															$ciudad6=$_POST['ciudadM6'];
														}

														if (!isset($_POST['ciudadM7'])){
															$ciudad7="";
														}else {

															$ciudad7=$_POST['ciudadM7'];
														}

														if (!isset($_POST['ciudadM8'])){
															$ciudad8="";
														}else {

															$ciudad8=$_POST['ciudadM8'];
														}

														if (!isset($_POST['ciudadM9'])){
															$ciudad9="";
														}else {

															$ciudad9=$_POST['ciudadM9'];
														}

														if (!isset($_POST['ciudadM10'])){
															$ciudad10="";
														}else {

															$ciudad10=$_POST['ciudadM10'];
														}

														if (!isset($_POST['ciudadM11'])){
															$ciudad11="";
														}else {

															$ciudad11=$_POST['ciudadM11'];
														}

														if (!isset($_POST['ciudadM12'])){
															$ciudad12="";
														}else {

															$ciudad12=$_POST['ciudadM12'];
														}

														if (!isset($_POST['ciudadM13'])){
															$ciudad13="";
														}else {

															$ciudad13=$_POST['ciudadM13'];
														}

														if (!isset($_POST['ciudadM14'])){
															$ciudad14="";
														}else {

															$ciudad14=$_POST['ciudadM14'];
														}

														if (!isset($_POST['ciudadM15'])){
															$ciudad15="";
														}else {

															$ciudad15=$_POST['ciudadM15'];
														}
														//-------------------------------------------------------

														if (!isset($_POST['estadoM2'])){
															$id_estado2=null;
														}else {

															$id_estado2=$_POST['estadoM2'];
														}

														if (!isset($_POST['estadoM3'])){
															$id_estado3=null;
														}else {

															$id_estado3=$_POST['estadoM3'];
														}

														if (!isset($_POST['estadoM4'])){
															$id_estado4=null;
														}else {

															$id_estado4=$_POST['estadoM4'];
														}

														if (!isset($_POST['estadoM5'])){
															$id_estado5=null;
														}else {

															$id_estado5=$_POST['estadoM5'];
														}

														if (!isset($_POST['estadoM6'])){
															$id_estado6=null;
														}else {

															$id_estado6=$_POST['estadoM6'];
														}

														if (!isset($_POST['estadoM7'])){
															$id_estado7=null;
														}else {

															$id_estado7=$_POST['estadoM7'];
														}

														if (!isset($_POST['estadoM8'])){
															$id_estado8=null;
														}else {

															$id_estado8=$_POST['estadoM8'];
														}

														if (!isset($_POST['estadoM9'])){
															$id_estado9=null;
														}else {

															$id_estado9=$_POST['estadoM9'];
														}

														if (!isset($_POST['estadoM10'])){
															$id_estado10=null;
														}else {

															$id_estado10=$_POST['estadoM10'];
														}

														if (!isset($_POST['estadoM11'])){
															$id_estado11=null;
														}else {

															$id_estado11=$_POST['estadoM11'];
														}

														if (!isset($_POST['estadoM12'])){
															$id_estado12=null;
														}else {

															$id_estado12=$_POST['estadoM12'];
														}

														if (!isset($_POST['estadoM13'])){
															$id_estado13=null;
														}else {

															$id_estado13=$_POST['estadoM13'];
														}

														if (!isset($_POST['estadoM14'])){
															$id_estado14=null;
														}else {

															$id_estado14=$_POST['estadoM14'];
														}

														if (!isset($_POST['estadoM15'])){
															$id_estado15=null;
														}else {

															$id_estado15=$_POST['estadoM15'];
														}

														//-------------------------------------------------------


														
														



													

											

														
														
														







			
		$this->clientesj->save(['nombre'=> $this->request->getPost('nombreM'),
								'folioCliente'=>$folioLitigante,
								'id_contacto'=>$this->request->getPost('id_contactoM'),
								
								'calle'=>$this->request->getPost('calleM'),
								'cp'=>$this->request->getPost('cpM'),
								'colonia'=>$this->request->getPost('coloniaM'),
								'ciudad'=>$this->request->getPost('ciudadM'),
								'id_estado'=>$this->request->getPost('estadoM'),
								
								'telefono'=>$b,
								'celular'=>$d,
								'email'=>$this->request->getPost('emailM'),
								'rfc'=>$this->request->getPost('rfcM'),
								'registroPatronal'=>$this->request->getPost('regPatronalM'),
								
								'comentarios'=>$this->request->getPost('comentariosM'),
								'moral_fisica'=>$this->request->getPost('tipoM'),

								//nombres de documentos y extensiones
								'ActaConstitutiva_nom'=> $ActaConstitutiva_nom,
								'ActaConstitutiva_ext'=>$ActaConstitutiva_ext,
								'PoderNotarial_nom'=>$PoderNotarial_nom,
								'PoderNotarial_ext'=>$PoderNotarial_ext,




				

							    'logoCliente'=>$logoCliente_nom,
								'logoCliente_ext'=>$logoCliente_ext, 
						
								'ConstanciaFiscal_nom'=>$ConstanciaFiscal_nom,
								'ConstanciaFiscal_ext'=>$ConstanciaFiscal_ext,

								'AperturaEstablecimiento_nom'=>$AperturaEstablecimiento_nom,
								'AperturaEstablecimiento_ext'=>$AperturaEstablecimiento_ext,
								'altaPatronalM_nom'=>$altaPatronalM_nom,
								'altaPatronalM_ext'=>$altaPatronalM_ext,

							
								'LicMunicipal_nom'=>$LicMunicipal_nom,
								'LicMunicipal_ext'=>$LicMunicipal_ext,

								'ComprobanteDomicilio_nom'=>$ComprobanteDomicilio_nom,
								'ComprobanteDomicilio_ext'=>$ComprobanteDomicilio_ext,
								'PoderAbogado_nom'=>$PoderAbogado_nom,
								'PoderAbogado_ext'=>$PoderAbogado_ext,
								'RegRep_nom'=>$RegRep_nom,
								'RegRep_ext'=>$RegRep_ext,


								'identificacionRepresentaLegal_nom'=>$identificacionRepresentaLegal_nom,
								'identificacionRepresentaLegal_ext'=>$identificacionRepresentaLegal_ext,

								'identificacionApoderado_nom'=>$identificacionApoderado_nom,
								'identificacionApoderado_ext'=>$identificacionApoderado_ext,

								'rfcRepresenta_nom'=>$rfcRepresenta_nom,
								'rfcRepresenta_ext'=>$rfcRepresenta_ext,

								'curpRepresenta_nom'=>$curpRepresenta_nom,
								'curpRepresenta_ext'=>$curpRepresenta_ext,


								
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
								
								
								'calle2'=>$calle2,
								'calle3'=>$calle3,
								'calle4'=>$calle4,
								'calle5'=>$calle5,
								'calle6'=>$calle6,
								'calle7'=>$calle7,
								'calle8'=>$calle8,
								'calle9'=>$calle9,
								'calle10'=>$calle10,
								'calle11'=>$calle11,
								'calle12'=>$calle12,
								'calle13'=>$calle13,
								'calle14'=>$calle14,
								'calle15'=>$calle15,


								'cp2'=>$cp2,
								'cp3'=>$cp3,
								'cp4'=>$cp4,
								'cp5'=>$cp5,
								'cp6'=>$cp6,
								'cp7'=>$cp7,
								'cp8'=>$cp8,
								'cp9'=>$cp9,
								'cp10'=>$cp10,
								'cp11'=>$cp11,
								'cp12'=>$cp12,
								'cp13'=>$cp13,
								'cp14'=>$cp14,
								'cp15'=>$cp15,

								'colonia2'=>$colonia2,
								'colonia3'=>$colonia3,
								'colonia4'=>$colonia4,
								'colonia5'=>$colonia5,
								'colonia6'=>$colonia6,
								'colonia7'=>$colonia7,
								'colonia8'=>$colonia8,
								'colonia9'=>$colonia9,
								'colonia10'=>$colonia10,
								'colonia11'=>$colonia11,
								'colonia12'=>$colonia12,
								'colonia13'=>$colonia13,
								'colonia14'=>$colonia14,
								'colonia15'=>$colonia15,


								'ciudad2'=>$ciudad2,
								'ciudad3'=>$ciudad3,
								'ciudad4'=>$ciudad4,
								'ciudad5'=>$ciudad5,
								'ciudad6'=>$ciudad6,
								'ciudad7'=>$ciudad7,
								'ciudad8'=>$ciudad8,
								'ciudad9'=>$ciudad9,
								'ciudad10'=>$ciudad10,
								'ciudad11'=>$ciudad11,
								'ciudad12'=>$ciudad12,
								'ciudad13'=>$ciudad13,
								'ciudad14'=>$ciudad14,
								'ciudad15'=>$ciudad15,




								'id_estado2'=>$id_estado2,
								'id_estado3'=>$id_estado3,
								'id_estado4'=>$id_estado4,
								'id_estado5'=>$id_estado5,
								'id_estado6'=>$id_estado6,
								'id_estado7'=>$id_estado7,
								'id_estado8'=>$id_estado8,
								'id_estado9'=>$id_estado9,
								'id_estado10'=>$id_estado10,
								'id_estado11'=>$id_estado11,
								'id_estado12'=>$id_estado12,
								'id_estado13'=>$id_estado13,
								'id_estado14'=>$id_estado14,
								'id_estado15'=>$id_estado15,











								]);
		
					
	return redirect()->to(base_url().'/clientesj');
		
	}
}
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------

//--------------------------------------------------------------------------------------------------------------------------------------------------------------
public function detalles_m($id, $valid=null){
	if (!isset($this->session->id_usuario)){
		return redirect()->to(base_url());
	}
   $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'ClientesEditar');
	
	if(!$permiso){
		
		
		
		
		return redirect()->to(base_url().'/clientes');
	   
	   
		
	}
	












	$estadoss=$this->estados->findAll();
	$contactocliente=$this->contactoconcliente->findAll();
	$clientesj=$this->clientesj->where('id',$id)->first();
	




	$data=['titulo'=>'Catálogo de clientes','datos'=>$clientesj,'estados'=>$estadoss,'contactoCliente'=>$contactocliente];
	










	
	
	

	echo view('header');
	echo view('clientesj/detalles_m', $data);
	echo view('footer');
	
}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------

//--------------------------------------------------------------------------------------------------------------------------------------------------------------
public function editarM($id, $valid=null){
	if (!isset($this->session->id_usuario)){
		return redirect()->to(base_url());
	}
   $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'ClientesEditar');
	
	if(!$permiso){
		
		
		
		
		return redirect()->to(base_url().'/clientes');
	   
	   
		
	}
	












	$estadoss=$this->estados->findAll();
	$contactocliente=$this->contactoconcliente->findAll();
	$clientesj=$this->clientesj->where('id',$id)->first();
	




	$data=['titulo'=>'Catálogo de clientes','datos'=>$clientesj,'estados'=>$estadoss,'contactoCliente'=>$contactocliente];
	










	
	
	

	echo view('header');
	echo view('clientesj/editarM', $data);
	echo view('footer');
	
}


//--------------------------------------------------------------------------------------------------------------------------------------------------------------
public function actualizarMoral_(){

	if (!isset($this->session->id_usuario)){
		return redirect()->to(base_url());
	}
	
		if($this->request->getMethod()=="post"){



			$folioLitigante=$_POST['folioLitigante'];
	
			$a=$_POST['telefonoM'];
			$b = str_replace('-', '', $a );
			$c=$_POST['celularM'];
			$d= str_replace('-', '', $c );

			$logoCliente=$this->request->getFile('logoCliente');
			$ActaConstitutiva=$this->request->getFile('ActaConstitutiva');

			$PoderNotarial=$this->request->getFile('PoderNotarial');

			$AperturaEstablecimientoM=$this->request->getFile('AperturaEstablecimientoM');

			$ConstanciaSituacionfiscalM=$this->request->getFile('ConstanciaSituacionfiscalM');

			$altaPatronalM=$this->request->getFile('altaPatronalM');

			$LicMunicipalM=$this->request->getFile('LicMunicipalM');

			$ComprobanteDomicilioM=$this->request->getFile('ComprobanteDomicilioM');

			$PoderAbogadoM=$this->request->getFile('PoderAbogadoM');

			$RegRepM=$this->request->getFile('RegRepM');

			$identificacionRepresentaLegal=$this->request->getFile('identificacionRepresentaLegal');

			$identificacionApoderado=$this->request->getFile('identificacionApoderado');

			$curpRepresenta=$this->request->getFile('curpRepresenta');
			$rfcRepresenta=$this->request->getFile('rfcRepresenta');




			$logoCliente_nom=$_POST['logoCliente_nom'];
			$ActaConstitutiva_nom=$_POST['ActaConstitutiva_nom'];
			$PoderNotarial_nom=$_POST['PoderNotarial_nom'];
			$AperturaEstablecimiento_nom=$_POST['AperturaEstablecimiento_nom'];
			$ConstanciaFiscal_nom=$_POST['ConstanciaFiscal_nom'];
			$altaPatronalM_nom=$_POST['altaPatronalM_nom'];
			$LicMunicipal_nom=$_POST['LicMunicipal_nom'];
			$ComprobanteDomicilio_nom=$_POST['ComprobanteDomicilio_nom'];
			$PoderAbogado_nom=$_POST['PoderAbogado_nom'];
			$RegRep_nom=$_POST['RegRep_nom'];
			$identificacionRepresentaLegal_nom=$_POST['identificacionRepresentaLegal_nom'];
			$identificacionApoderado_nom=$_POST['identificacionApoderado_nom'];
			$rfcRepresenta_nom=$_POST['rfcRepresenta_nom'];
			$curpRepresenta_nom=$_POST['curpRepresenta_nom'];




			$logoCliente_ext=$_POST['logoCliente_ext'];
			$ActaConstitutiva_ext=$_POST['ActaConstitutiva_ext'];
			$PoderNotarial_ext=$_POST['PoderNotarial_ext'];
			$AperturaEstablecimiento_ext=$_POST['AperturaEstablecimiento_ext'];
			$ConstanciaFiscal_ext=$_POST['ConstanciaFiscal_ext'];
			$altaPatronalM_ext=$_POST['altaPatronalM_ext'];
			$LicMunicipal_ext=$_POST['LicMunicipal_ext'];
			$ComprobanteDomicilio_ext=$_POST['ComprobanteDomicilio_ext'];
			$PoderAbogado_ext=$_POST['PoderAbogado_ext'];
			$RegRep_ext=$_POST['RegRep_ext'];
			$identificacionRepresentaLegal_ext=$_POST['identificacionRepresentaLegal_ext'];
			$identificacionApoderado_ext=$_POST['identificacionApoderado_ext'];
			$rfcRepresenta_ext=$_POST['rfcRepresenta_ext'];
			$curpRepresenta_ext=$_POST['curpRepresenta_ext'];










			if ($logoCliente != ""){

				$logoCliente=$this->request->getFile('logoCliente');
				
				$archivo_name=$_FILES['logoCliente']['name'];
				
				$extension = explode(".",$archivo_name);
				$num = count($extension)-1;
				
				
				
				
				
				
					//borrar archivo en caso de que ya exista 
					$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-logoCliente.$extension[$num]";
					
				
					if (file_exists($rutaDoc)){
				
						unlink($rutaDoc);
						$carpeta="./dist/img/cliente/expediente/";
						if (!file_exists($carpeta)){
				
							mkdir($carpeta,077,true);
						}
				
					}
					
												
				
				
				$logoCliente->move("./dist/img/cliente/expediente/", "$folioLitigante-logoCliente.$extension[$num]");
				
				
				
				
				
				$logoCliente_nom="$folioLitigante-logoCliente.$extension[$num]";
				$logoCliente_ext="$extension[$num]";
				
				
				
				
				
							//----------------------------------------------insertamos 
				
				}









			




			if ($ActaConstitutiva != ""){

				$ActaConstitutiva=$this->request->getFile('ActaConstitutiva');
				
				$archivo_name=$_FILES['ActaConstitutiva']['name'];
				
				$extension = explode(".",$archivo_name);
				$num = count($extension)-1;
				
				
				
				
				
				
					//borrar archivo en caso de que ya exista 
					$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-ActaConstitutiva.$extension[$num]";
					
				
					if (file_exists($rutaDoc)){
				
						unlink($rutaDoc);
						$carpeta="./dist/img/cliente/expediente/";
						if (!file_exists($carpeta)){
				
							mkdir($carpeta,077,true);
						}
				
					}
					
												
				
				
				$ActaConstitutiva->move("./dist/img/cliente/expediente/", "$folioLitigante-ActaConstitutiva.$extension[$num]");
				
				
				
				
				
				$ActaConstitutiva_nom="$folioLitigante-ActaConstitutiva.$extension[$num]";
				$ActaConstitutiva_ext="$extension[$num]";
				
				
				
				
				
							//----------------------------------------------insertamos 
				
				}




			if ($PoderNotarial != ""){

				$PoderNotarial=$this->request->getFile('PoderNotarial');
				
				$archivo_name=$_FILES['PoderNotarial']['name'];
				
				$extension = explode(".",$archivo_name);
				$num = count($extension)-1;
				
				
				
				
				
				
					//borrar archivo en caso de que ya exista 
					$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-PoderNotarial.$extension[$num]";
					
				
					if (file_exists($rutaDoc)){
				
						unlink($rutaDoc);
						$carpeta="./dist/img/cliente/expediente/";
						if (!file_exists($carpeta)){
				
							mkdir($carpeta,077,true);
						}
				
					}
					
												
				
				
				$PoderNotarial->move("./dist/img/cliente/expediente/", "$folioLitigante-PoderNotarial.$extension[$num]");
				
				
				
				
				
				$PoderNotarial_nom="$folioLitigante-PoderNotarial.$extension[$num]";
				$PoderNotarial_ext="$extension[$num]";
				
				
				
				
				
							//----------------------------------------------insertamos 
				
				}


				if ($AperturaEstablecimientoM != ""){

					$AperturaEstablecimientoM=$this->request->getFile('AperturaEstablecimientoM');
					
					$archivo_name=$_FILES['AperturaEstablecimientoM']['name'];
					
					$extension = explode(".",$archivo_name);
					$num = count($extension)-1;
					
					
					
					
					
					
						//borrar archivo en caso de que ya exista 
						$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-AperturaEstablecimientoM.$extension[$num]";
						
					
						if (file_exists($rutaDoc)){
					
							unlink($rutaDoc);
							$carpeta="./dist/img/cliente/expediente/";
							if (!file_exists($carpeta)){
					
								mkdir($carpeta,077,true);
							}
					
						}
						
													
					
					
					$AperturaEstablecimientoM->move("./dist/img/cliente/expediente/", "$folioLitigante-AperturaEstablecimientoM.$extension[$num]");
					
					
					
					
					
					$AperturaEstablecimiento_nom="$folioLitigante-AperturaEstablecimientoM.$extension[$num]";
					$AperturaEstablecimiento_ext="$extension[$num]";
					
					
					
					
					
								//----------------------------------------------insertamos 
					
					}





					if ($ConstanciaSituacionfiscalM != ""){

						$ConstanciaSituacionfiscalM=$this->request->getFile('ConstanciaSituacionfiscalM');
						
						$archivo_name=$_FILES['ConstanciaSituacionfiscalM']['name'];
						
						$extension = explode(".",$archivo_name);
						$num = count($extension)-1;
						
						
						
						
						
						
							//borrar archivo en caso de que ya exista 
							$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-ConstanciaSituacionfiscalM.$extension[$num]";
							
						
							if (file_exists($rutaDoc)){
						
								unlink($rutaDoc);
								$carpeta="./dist/img/cliente/expediente/";
								if (!file_exists($carpeta)){
						
									mkdir($carpeta,077,true);
								}
						
							}
							
														
						
						
						$ConstanciaSituacionfiscalM->move("./dist/img/cliente/expediente/", "$folioLitigante-ConstanciaSituacionfiscalM.$extension[$num]");
						
						
						
						
						
						$ConstanciaFiscal_nom="$folioLitigante-ConstanciaSituacionfiscalM.$extension[$num]";
						$ConstanciaFiscal_ext="$extension[$num]";
						
						
						
						
						
									//----------------------------------------------insertamos 
						
						}


						if ($altaPatronalM != ""){

							$altaPatronalM=$this->request->getFile('altaPatronalM');
							
							$archivo_name=$_FILES['altaPatronalM']['name'];
							
							$extension = explode(".",$archivo_name);
							$num = count($extension)-1;
							
							
							
							
							
							
								//borrar archivo en caso de que ya exista 
								$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-altaPatronalM.$extension[$num]";
								
							
								if (file_exists($rutaDoc)){
							
									unlink($rutaDoc);
									$carpeta="./dist/img/cliente/expediente/";
									if (!file_exists($carpeta)){
							
										mkdir($carpeta,077,true);
									}
							
								}
								
															
							
							
							$altaPatronalM->move("./dist/img/cliente/expediente/", "$folioLitigante-altaPatronalM.$extension[$num]");
							
							
							
							
							
							$altaPatronalM_nom="$folioLitigante-altaPatronalM.$extension[$num]";
							$altaPatronalM_ext="$extension[$num]";
							
							
							
							
							
										//----------------------------------------------insertamos 
							
							}




							if ($LicMunicipalM != ""){

								$LicMunicipalM=$this->request->getFile('LicMunicipalM');
								
								$archivo_name=$_FILES['LicMunicipalM']['name'];
								
								$extension = explode(".",$archivo_name);
								$num = count($extension)-1;
								
								
								
								
								
								
									//borrar archivo en caso de que ya exista 
									$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-LicMunicipalM.$extension[$num]";
									
								
									if (file_exists($rutaDoc)){
								
										unlink($rutaDoc);
										$carpeta="./dist/img/cliente/expediente/";
										if (!file_exists($carpeta)){
								
											mkdir($carpeta,077,true);
										}
								
									}
									
																
								
								
								$LicMunicipalM->move("./dist/img/cliente/expediente/", "$folioLitigante-LicMunicipalM.$extension[$num]");
								
								
								
								
								
								$LicMunicipal_nom="$folioLitigante-LicMunicipalM.$extension[$num]";
								$LicMunicipal_ext="$extension[$num]";
								
								
								
								
								
											//----------------------------------------------insertamos 
								
								}



								if ($ComprobanteDomicilioM != ""){

									$ComprobanteDomicilioM=$this->request->getFile('ComprobanteDomicilioM');
									
									$archivo_name=$_FILES['ComprobanteDomicilioM']['name'];
									
									$extension = explode(".",$archivo_name);
									$num = count($extension)-1;
									
									
									
									
									
									
										//borrar archivo en caso de que ya exista 
										$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-ComprobanteDomicilioM.$extension[$num]";
										
									
										if (file_exists($rutaDoc)){
									
											unlink($rutaDoc);
											$carpeta="./dist/img/cliente/expediente/";
											if (!file_exists($carpeta)){
									
												mkdir($carpeta,077,true);
											}
									
										}
										
																	
									
									
									$ComprobanteDomicilioM->move("./dist/img/cliente/expediente/", "$folioLitigante-ComprobanteDomicilioM.$extension[$num]");
									
									
									
									
									
									$ComprobanteDomicilio_nom="$folioLitigante-ComprobanteDomicilioM.$extension[$num]";
									$ComprobanteDomicilio_ext="$extension[$num]";
									
									
									
									
									
												//----------------------------------------------insertamos 
									
									}





									if ($PoderAbogadoM != ""){

										$PoderAbogadoM=$this->request->getFile('PoderAbogadoM');
										
										$archivo_name=$_FILES['PoderAbogadoM']['name'];
										
										$extension = explode(".",$archivo_name);
										$num = count($extension)-1;
										
										
										
										
										
										
											//borrar archivo en caso de que ya exista 
											$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-PoderAbogadoM.$extension[$num]";
											
										
											if (file_exists($rutaDoc)){
										
												unlink($rutaDoc);
												$carpeta="./dist/img/cliente/expediente/";
												if (!file_exists($carpeta)){
										
													mkdir($carpeta,077,true);
												}
										
											}
											
																		
										
										
										$PoderAbogadoM->move("./dist/img/cliente/expediente/", "$folioLitigante-PoderAbogadoM.$extension[$num]");
										
										
										
										
										
										$PoderAbogado_nom="$folioLitigante-PoderAbogadoM.$extension[$num]";
										$PoderAbogado_ext="$extension[$num]";
										
										
										
										
										
													//----------------------------------------------insertamos 
										
										}


										if ($RegRepM != ""){

											$RegRepM=$this->request->getFile('RegRepM');
											
											$archivo_name=$_FILES['RegRepM']['name'];
											
											$extension = explode(".",$archivo_name);
											$num = count($extension)-1;
											
											
											
											
											
											
												//borrar archivo en caso de que ya exista 
												$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-RegRepM.$extension[$num]";
												
											
												if (file_exists($rutaDoc)){
											
													unlink($rutaDoc);
													$carpeta="./dist/img/cliente/expediente/";
													if (!file_exists($carpeta)){
											
														mkdir($carpeta,077,true);
													}
											
												}
												
																			
											
											
											$RegRepM->move("./dist/img/cliente/expediente/", "$folioLitigante-RegRepM.$extension[$num]");
											
											
											
											
											
											$RegRep_nom="$folioLitigante-RegRepM.$extension[$num]";
											$RegRep_ext="$extension[$num]";
											
											
											
											
											
														//----------------------------------------------insertamos 
											
											}




											if ($identificacionRepresentaLegal != ""){

												$identificacionRepresentaLegal=$this->request->getFile('identificacionRepresentaLegal');
												
												$archivo_name=$_FILES['identificacionRepresentaLegal']['name'];
												
												$extension = explode(".",$archivo_name);
												$num = count($extension)-1;
												
												
												
												
												
												
													//borrar archivo en caso de que ya exista 
													$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-identificacionRepresentaLegal.$extension[$num]";
													
												
													if (file_exists($rutaDoc)){
												
														unlink($rutaDoc);
														$carpeta="./dist/img/cliente/expediente/";
														if (!file_exists($carpeta)){
												
															mkdir($carpeta,077,true);
														}
												
													}
													
																				
												
												
												$identificacionRepresentaLegal->move("./dist/img/cliente/expediente/", "$folioLitigante-identificacionRepresentaLegal.$extension[$num]");
												
												
												
												
												
												$identificacionRepresentaLegal_nom="$folioLitigante-identificacionRepresentaLegal.$extension[$num]";
												$identificacionRepresentaLegal_ext="$extension[$num]";
												
												
												
												
												
															//----------------------------------------------insertamos 
												
												}
	

												if ($identificacionApoderado != ""){

													$identificacionApoderado=$this->request->getFile('identificacionApoderado');
													
													$archivo_name=$_FILES['identificacionApoderado']['name'];
													
													$extension = explode(".",$archivo_name);
													$num = count($extension)-1;
													
													
													
													
													
													
														//borrar archivo en caso de que ya exista 
														$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-identificacionApoderado.$extension[$num]";
														
													
														if (file_exists($rutaDoc)){
													
															unlink($rutaDoc);
															$carpeta="./dist/img/cliente/expediente/";
															if (!file_exists($carpeta)){
													
																mkdir($carpeta,077,true);
															}
													
														}
														
																					
													
													
													$identificacionApoderado->move("./dist/img/cliente/expediente/", "$folioLitigante-identificacionApoderado.$extension[$num]");
													
													
													
													
													
													$identificacionApoderado_nom="$folioLitigante-identificacionApoderado.$extension[$num]";
													$identificacionApoderado_ext="$extension[$num]";
													
													
													
													
													
																//----------------------------------------------insertamos 
													
													}
		

													
												if ($rfcRepresenta != ""){

													$rfcRepresenta=$this->request->getFile('rfcRepresenta');
													
													$archivo_name=$_FILES['rfcRepresenta']['name'];
													
													$extension = explode(".",$archivo_name);
													$num = count($extension)-1;
													
													
													
													
													
													
														//borrar archivo en caso de que ya exista 
														$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-rfcRepresenta.$extension[$num]";
														
													
														if (file_exists($rutaDoc)){
													
															unlink($rutaDoc);
															$carpeta="./dist/img/cliente/expediente/";
															if (!file_exists($carpeta)){
													
																mkdir($carpeta,077,true);
															}
													
														}
														
																					
													
													
													$rfcRepresenta->move("./dist/img/cliente/expediente/", "$folioLitigante-rfcRepresenta.$extension[$num]");
													
													
													
													
													
													$rfcRepresenta_nom="$folioLitigante-rfcRepresenta.$extension[$num]";
													$rfcRepresenta_ext="$extension[$num]";
													
													
													
													
													
																//----------------------------------------------insertamos 
													
													}






														if ($curpRepresenta != ""){

														$curpRepresenta=$this->request->getFile('curpRepresenta');
														
														$archivo_name=$_FILES['curpRepresenta']['name'];
														
														$extension = explode(".",$archivo_name);
														$num = count($extension)-1;
														
														
														
														
														
														
															//borrar archivo en caso de que ya exista 
															$rutaDoc = "./dist/img/cliente/expediente/$folioLitigante-curpRepresenta.$extension[$num]";
															
														
															if (file_exists($rutaDoc)){
														
																unlink($rutaDoc);
																$carpeta="./dist/img/cliente/expediente/";
																if (!file_exists($carpeta)){
														
																	mkdir($carpeta,077,true);
																}
														
															}
															
																						
														
														
														$curpRepresenta->move("./dist/img/cliente/expediente/", "$folioLitigante-curpRepresenta.$extension[$num]");
														
														
														
														
														
														$curpRepresenta_nom="$folioLitigante-curpRepresenta.$extension[$num]";
														$curpRepresenta_ext="$extension[$num]";
														
														
														
														
														
																	//----------------------------------------------insertamos 
														
														}





														$id=$this->request->getPost('id');
	
														$this->clientesj->update($id,['nombre'=> $this->request->getPost('nombreM'),
		
													
														'folioCliente'=>$folioLitigante,
														'id_contacto'=>$this->request->getPost('id_contactoM'),
														
														'calle'=>$this->request->getPost('calleM'),
														'cp'=>$this->request->getPost('cpM'),
														'colonia'=>$this->request->getPost('coloniaM'),
														'ciudad'=>$this->request->getPost('ciudadM'),
														'id_estado'=>$this->request->getPost('estadoM'),
														
														'telefono'=>$b,
														'celular'=>$d,
														'email'=>$this->request->getPost('emailM'),
														'rfc'=>$this->request->getPost('rfcM'),
														'registroPatronal'=>$this->request->getPost('regPatronalM'),
														
														'comentarios'=>$this->request->getPost('comentariosM'),
														'moral_fisica'=>$this->request->getPost('tipoM'),
						
														//nombres de documentos y extensiones
														'ActaConstitutiva_nom'=> $ActaConstitutiva_nom,
														'ActaConstitutiva_ext'=>$ActaConstitutiva_ext,
														'PoderNotarial_nom'=>$PoderNotarial_nom,
														'PoderNotarial_ext'=>$PoderNotarial_ext,
						
						
						
						
										
						
														'logoCliente'=>$logoCliente_nom,
														'logoCliente_ext'=>$logoCliente_ext, 
												
														'ConstanciaFiscal_nom'=>$ConstanciaFiscal_nom,
														'ConstanciaFiscal_ext'=>$ConstanciaFiscal_ext,
						
														'AperturaEstablecimiento_nom'=>$AperturaEstablecimiento_nom,
														'AperturaEstablecimiento_ext'=>$AperturaEstablecimiento_ext,
														'altaPatronalM_nom'=>$altaPatronalM_nom,
														'altaPatronalM_ext'=>$altaPatronalM_ext,
						
													
														'LicMunicipal_nom'=>$LicMunicipal_nom,
														'LicMunicipal_ext'=>$LicMunicipal_ext,
						
														'ComprobanteDomicilio_nom'=>$ComprobanteDomicilio_nom,
														'ComprobanteDomicilio_ext'=>$ComprobanteDomicilio_ext,
														'PoderAbogado_nom'=>$PoderAbogado_nom,
														'PoderAbogado_ext'=>$PoderAbogado_ext,
														'RegRep_nom'=>$RegRep_nom,
														'RegRep_ext'=>$RegRep_ext,
						
						
														'identificacionRepresentaLegal_nom'=>$identificacionRepresentaLegal_nom,
														'identificacionRepresentaLegal_ext'=>$identificacionRepresentaLegal_ext,
						
														'identificacionApoderado_nom'=>$identificacionApoderado_nom,
														'identificacionApoderado_ext'=>$identificacionApoderado_ext,
						
														'rfcRepresenta_nom'=>$rfcRepresenta_nom,
														'rfcRepresenta_ext'=>$rfcRepresenta_ext,
						
														'curpRepresenta_nom'=>$curpRepresenta_nom,
														'curpRepresenta_ext'=>$curpRepresenta_ext
						
						
						
						
						
						
						
						
						
						
														]);
								














					
	return redirect()->to(base_url().'/clientesj');
		
	}
}






//--------------------------------------------------------------------------------------------------------------------------------------------------------------

























	
	
	
}






?>