<?php 

namespace App\Controllers;
use App\Models\areasapoyoModels;
use App\Models\checkModels;
use App\Models\detalle_roles_permisosModels;

class Aapoyo extends BaseController{
	
	protected $aapoyo;
	protected $checklist;
	protected $reglas,$session,$detalleRolesPermisos;
	
	public function __construct(){
		
		$this->aapoyo=new AreasapoyoModels();
		$this->checklist=new CheckModels();
        $this->session=session();
        $this->detalleRolesPermisos=new detalle_roles_permisosModels();
	helper(['form']);
		$this->reglas=[
			'nombre'=>[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.'
					   ]
			]
			
			];
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
public function index($activo=1){
        

if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
    
    $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'SubCategorias');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/inicio');
           
           
            
        }
		$areas=$this->aapoyo->where('activo',$activo)->findAll();
		$data=['titulo'=>'Áreas de apoyo','datos'=>$areas];
		
		
        echo view('header');
		echo view('aApoyo/aApoyo', $data);
		echo view('footer');
		
	}
	
	


//--------------------------------------------------------------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
public function asignar($id){
        

	if (!isset($this->session->id_usuario)){
				return redirect()->to(base_url());
			}
		
		$permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'SubCategorias');
			
			if(!$permiso){
				
				
				
				
				return redirect()->to(base_url().'/inicio');
			   
			   
				
			}

				$activo=1;

			$check=$this->checklist->where('activo',$activo)->findAll();


			$data=['titulo'=>'Asignar checklist','datos'=>$check, 'id'=>$id];
			
			
			echo view('header');
			echo view('aApoyo/aCheck', $data);
			echo view('footer');
			
		}
		
		
	
	
	//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	
	public function insertar(){
		

				if (!isset($this->session->id_usuario)){
							return redirect()->to(base_url());
						}

						if($this->request->getMethod()=="post"){

						$this->aapoyo->save(['nombreArea'=> $this->request->getPost('nombre')]);

						return redirect()->to(base_url().'/Aapoyo');
						
						}
		
		
       
		
			
		
        
		
	}
	

//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	
	public function actualizar(){
		

if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		if($this->request->getMethod()=="post" ){
		$this->aapoyo->update($this->request->getPost('id'),[ 'nombreArea'=>$this->request->getPost('nombre')]);
		return redirect()->to(base_url().'/Aapoyo');
		
		}
		
	}
	
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function eliminar($id){
        

if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		
        $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'CategoriasEliminar');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/Aapoyo');
           
           
            
        }
		
		$this->aapoyo->update($id,['activo'=> 0]);
		return redirect()->to(base_url().'/Aapoyo');
		
		
        
		
	}
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------	
	public function eliminados($activo=0){
        

if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        
        $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'CategoriasEliminados');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/categorias');
           
           
            
        }
		$categorias=$this->aapoyo->where('activo',$activo)->findAll();
		$data=['titulo'=>'Áreas de apoyo eliminadas','datos'=>$categorias];
		
		
        echo view('header');
		echo view('Aapoyo/eliminadas', $data);
		echo view('footer');
		
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	
		public function reingresar($id){
            

if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		
		
		$this->aapoyo->update($id,['activo'=> 1]);
		return redirect()->to(base_url().'/Aapoyo');
		
		
        
		
	}
	
	
	
}






?>