<?php 

namespace App\Controllers;
use App\Models\rolesModels;
use App\Models\permisosModels;
use App\Models\detalle_roles_permisosModels;

class Roles extends BaseController{
	
	protected $roles,$permisos,$detalleRolesPermisos;
	protected $reglas,$session;
	
	
	public function __construct(){
		
		$this->roles=new RolesModels();
        $this->permisos=new permisosModels();
        $this->detalleRolesPermisos=new detalle_roles_permisosModels();
        
        
        
        $this->session=session();
		helper(['form']);
		$this->reglas=[
			'nombre'=>[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.'
					   ]
			]
			
			];
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function index($activo=1){
        
        
        
        
        
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        
        $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'SubRoles');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/inicio');
           
           
            
        }
		$roles=$this->roles->where('activo',$activo)->findAll();
		$data=['titulo'=>'Tipo de permisos','datos'=>$roles];
		
		
        echo view('header');
		echo view('roles/roles', $data);
		echo view('footer');
		
	}
	
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function agregar(){
        
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		 $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'RolesAgregar');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/roles');
           
           
            
        }
		
		$data=['titulo'=>'Agregar rol'];
		
		
        echo view('header');
		echo view('roles/agregar', $data);
		echo view('footer');
		
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function insertar(){
		
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		if($this->request->getMethod()=="post" && $this->validate($this->reglas)){
			
			$this->roles->save(['nombre'=> $this->request->getPost('nombre')]);
		return redirect()->to(base_url().'/roles');
			
		}
		
		else {
			$data=['titulo'=>'Agregar rol', 'validation'=> $this->validator];
		
		
        echo view('header');
		echo view('roles/agregar', $data);
		echo view('footer');
			
		}
		
        
		
	}
	
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function editar($id, $valid=null){
        
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'RolesEditar');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/roles');
           
           
            
        }
		
		$rol = $this->roles->where('id',$id)->first();
		
		if($valid != null){
			$data=['titulo'=>'Editar rol', 'datos'=>$rol, 'validation'=> $valid];
		}
		else {
			$data=['titulo'=>'Editar rol', 'sebast'=>$rol];
		}
		
		
		
        echo view('header');
		echo view('roles/editar', $data);
		echo view('footer');
		
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function actualizar(){
		
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		
		
		if($this->request->getMethod()=="post" && $this->validate($this->reglas)){
		
		$this->roles->update($this->request->getPost('id'),[ 'nombre'=>$this->request->getPost('nombre')]);
		return redirect()->to(base_url().'/roles');
		
		
		}else{
			
			return $this->editar($this->request->getPost('id'),$this->validator);
			
		}
		
	}
	
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function eliminar($id){
        
		
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'RolesEliminar');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/roles');
           
           
            
        }
		
		$this->roles->update($id,['activo'=> 0]);
		return redirect()->to(base_url().'/roles');
		
		
        
		
	}
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function eliminados($activo=0){
        
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'RolesEliminados');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/roles');
           
           
            
        }
		$roles=$this->roles->where('activo',$activo)->findAll();
		$data=['titulo'=>'Roles eliminadas','datos'=>$roles];
		
		
        echo view('header');
		echo view('roles/eliminadas', $data);
		echo view('footer');
		
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
		public function reingresar($id){
            
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		
		
		$this->roles->update($id,['activo'=> 1]);
		return redirect()->to(base_url().'/roles');
		
		
        
		
	}
    
    
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
    public function detalles($idRol){
            
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		
        $permisos=$this->permisos->findAll();
        
		$permisosAsignados=$this->detalleRolesPermisos->where('id_rol',$idRol)->findAll();
        $datos=array();
        
    
        
        foreach($permisosAsignados as $permisoAsignado){
            
            $datos[$permisoAsignado['id_permiso']]=true;
            
        }
        
        
        $data=['titulo'=>'Permisos','permisos'=>$permisos, 'id_rol'=>$idRol,'asignado'=>$datos];
    
		 echo view('header');
		echo view('roles/detalles', $data);
		echo view('footer');
		
		
        
		
	}
	
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
        public function guardaPermisos(){
            
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		
        if ($this->request->getMethod()=="post"){
            
            
            
            $idRol=$this->request->getPost('id_rol');
            $permisos=$this->request->getPost('permisos');
            
            
            
            $this->detalleRolesPermisos->where('id_rol',$idRol)->delete();
            
            foreach($permisos as $permiso){
              
                
                $this->detalleRolesPermisos->save(['id_rol'=>$idRol,'id_permiso'=>$permiso]);
                
                
            }
            return redirect()->to(base_url().'/roles');
            
            
        }
		
        
		
	}
    
    
    
    
    
    
    
	
}






?>