<?php 

namespace App\Controllers;
use App\Models\configuracionesModels;
use App\Models\detalle_roles_permisosModels;


class Configuraciones extends BaseController{
	
	protected $configuraciones;
	protected $reglas,$session,$detalleRolesPermisos;
	

	
	
	public function __construct(){
		
		$this->configuraciones=new ConfiguracionesModels();
        $this->session=session();
        $this->detalleRolesPermisos=new detalle_roles_permisosModels();
	
		helper(['form']);
		$this->reglas=[
			'nombre_sistema'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.'
					   ]
				],
			
			'nombre_ticket'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.'
					   ]
				],
			'nombre_doctora'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.'
					   ]
				],
				'RFC'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.'
					   ]
				],
					'direccion'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.'
					   ]
				],
			'telefono'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.'
					   ]
				],
			'celular'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.'
					   ]
				],
				'correo'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.'
					   ]
				],
			'mensaje_gracias'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.'
					   ]
				],
			
			
			
			
			
			
			
			];
		
		
		
		
		
		
		
	}
	
	
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------	
	public function index($activo=1){
        if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		$permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'SubConfiguracion');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/inicio');
           
           
            
        }
		
		
		$nombre_ticket=$this->configuraciones->where('nombre','n_nombre_ticket')->first();
		$nombre_sistema=$this->configuraciones->where('nombre','n_nombre_sistema')->first();
		$nombre_doctora=$this->configuraciones->where('nombre','n_doctora')->first();
		$rfc=$this->configuraciones->where('nombre','n_rfc')->first();
		$direccion=$this->configuraciones->where('nombre','n_direccion')->first();
		$telefono=$this->configuraciones->where('nombre','n_telefono')->first();
		$celular=$this->configuraciones->where('nombre','n_celular')->first();
		
		$correo=$this->configuraciones->where('nombre','n_email')->first();
		$despedida=$this->configuraciones->where('nombre','n_ticket_gracias')->first();
		
		
		
		
		
		$data=['titulo'=>'Configuraciones','n_nombre_ticket'=>$nombre_ticket,'n_nombre_sistema'=>$nombre_sistema,'n_doctora'=>$nombre_doctora,'n_rfc'=>$rfc,'n_direccion'=>$direccion,'n_telefono'=>$telefono,'n_celular'=>$celular,'n_correo'=>$correo,'despedida'=>$despedida ];
		
		
        echo view('header');
		echo view('configuraciones/configuraciones',$data);
		echo view('footer');
		
	}
	
	


//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function actualizar(){
        if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		if($this->request->getMethod()=="post" && $this->validate($this->reglas)){
				
		    $this->configuraciones->whereIn('nombre',['n_nombre_sistema'])->set(['valor'=>$this->request->getPost('nombre_sistema')])->update();
			$this->configuraciones->whereIn('nombre',['n_nombre_ticket'])->set(['valor'=>$this->request->getPost('nombre_ticket')])->update();
			$this->configuraciones->whereIn('nombre',['n_doctora'])->set(['valor'=>$this->request->getPost('nombre_doctora')])->update();
			$this->configuraciones->whereIn('nombre',['n_rfc'])->set(['valor'=>$this->request->getPost('RFC')])->update();
			$this->configuraciones->whereIn('nombre',['n_direccion'])->set(['valor'=>$this->request->getPost('direccion')])->update();
			$this->configuraciones->whereIn('nombre',['n_telefono'])->set(['valor'=>$this->request->getPost('telefono')])->update();
			$this->configuraciones->whereIn('nombre',['n_celular'])->set(['valor'=>$this->request->getPost('celular')])->update();
			$this->configuraciones->whereIn('nombre',['n_email'])->set(['valor'=>$this->request->getPost('correo')])->update();
			$this->configuraciones->whereIn('nombre',['n_ticket_gracias'])->set(['valor'=>$this->request->getPost('mensaje_gracias')])->update();
		
            
            $validacion=$this->validate([
                'tienda_logo'=>[
                    'uploaded[tienda_logo]',
                    'mime_in[tienda_logo,image/png]',
                    'max_size[tienda_logo, 4096]'
                ]
            ]);
            if($validacion){
                $ruta_logo="./dist/img/logo/CENTRO-PIEL.png";
                if(file_exists($ruta_logo)){
                    
                    unlink($ruta_logo);
                }
               $img = $this->request->getFile('tienda_logo');
            $img->move('./dist/img/logo', 'CENTRO-PIEL.png'); 
            }else{
                
                echo 'error en validar';
                exit;
            }
            
            
		
		
		return redirect()->to(base_url().'/configuraciones');
		}else{
			
			return $this->editar($this->request->getPost('id'),$this->validator);
		}
		
        
		
	}
	
	
	

	
	
}






?>