<?php 

namespace App\Controllers;
use App\Models\clientesModels;
use App\Models\detalle_roles_permisosModels;


class Clientes extends BaseController{
	
	protected $clientes;
	protected $reglas,$session,$detalleRolesPermisos;
	

	
	
	public function __construct(){
		
		$this->clientes=new ClientesModels();
        $this->session=session();
        $this->detalleRolesPermisos=new detalle_roles_permisosModels();
	
		helper(['form']);
		$this->reglas=[
			'nombre'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.'
					   ]
				],
			'direccion'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo UNIDAD es obligatorio.'
					   ]
				],
			'telefono'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo CATEGORIA es obligatorio.'
					   ]
				],
			'correo'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo PRECIO VENTA es obligatorio.'
					   ]
				]	
			];
		
		
		
		
		
		
		
	}
	
	
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------	
	public function index($activo=1){
        if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'MenuClientes');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/inicio');
           
           
            
        }
        
        
        
		$clientes=$this->clientes->where('activo',$activo)->findAll();
		$data=['titulo'=>'Clientes','datos'=>$clientes];
		
		
        echo view('header');
		echo view('clientes/clientes', $data);
		echo view('footer');
		
	}
	
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function agregar(){
        if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
         $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'ClientesAgregar');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/clientes');
           
           
            
        }
		$clientes = $this->clientes->where('activo',1)->findAll();
		
		
		$data=['titulo'=>'Agregar cliente','clientes'=>$clientes];
		
		
        echo view('header');
		echo view('clientes/agregar', $data);
		echo view('footer');
		
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function insertar(){
        if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		
			if($this->request->getMethod()=="post" && $this->validate($this->reglas)){
		
		
			
			$this->clientes->save(['nombre'=> $this->request->getPost('nombre'),
									'direccion'=>$this->request->getPost('direccion'),
									'telefono'=>$this->request->getPost('telefono'),
									'correo'=>$this->request->getPost('correo')
									]);
			
		return redirect()->to(base_url().'/clientes');
			
		}
		
		else {
			
		
		
			$unidades = $this->unidades->where('activo',1)->findAll();
		$categorias=$this->categorias->where('activo',1)->findAll();
		
		$data=['titulo'=>'Agregar cliente','unidades'=>$unidades, 'categorias'=>$categorias, 'validation'=> $this->validator];
			
        echo view('header');
		echo view('clientes/agregar', $data);
		echo view('footer');
			
		}
		
        
		
	}
	
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function editar($id, $valid=null){
        if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
       $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'ClientesEditar');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/clientes');
           
           
            
        }
		
		
		$clientes=$this->clientes->where('id',$id)->first();
		
		if($valid != null){
		$data=['titulo'=>'Editar cliente','clientes'=>$clientes,'validation'=> $valid ];
		
		}else{
		$data=['titulo'=>'Editar cliente','clientes'=>$clientes ];	
			
		}
        echo view('header');
		echo view('clientes/editar', $data);
		echo view('footer');
		
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function actualizar(){
        if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		if($this->request->getMethod()=="post" && $this->validate($this->reglas)){
				
		$this->clientes->update($this->request->getPost('id'),[
									'nombre'=> $this->request->getPost('nombre'),
									'direccion'=>$this->request->getPost('direccion'),
									'telefono'=>$this->request->getPost('telefono'),
									'correo'=>$this->request->getPost('correo')
									]);
		
		
		
		
		return redirect()->to(base_url().'/clientes');
		}else{
			
			return $this->editar($this->request->getPost('id'),$this->validator);
		}
		
        
		
	}
	
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------	
	public function eliminar($id){
        
        
        if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        
         $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'ClientesEliminar');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/clientes');
           
           
            
        }
        
		
		
		$this->clientes->update($id,['activo'=> 0]);
		return redirect()->to(base_url().'/clientes');
		
		
        
		
	}
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function eliminados($activo=0){
        if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
         $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'ClientesEliminados');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/clientes');
           
           
            
        }
		$clientes=$this->clientes->where('activo',$activo)->findAll();
		$data=['titulo'=>'Clientes eliminadas','datos'=>$clientes];
		
		
        echo view('header');
		echo view('clientes/eliminadas', $data);
		echo view('footer');
		
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
		public function reingresar($id){
            if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		
		
		$this->clientes->update($id,['activo'=> 1]);
		return redirect()->to(base_url().'/clientes');
		
		
        
		
	}
	
//-------------------------------------------------------------------------------------------------------------------------------------------------------------- 
    public function autocompleteData(){
        if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		$returnData=array();
		
		$valor=$this->request->getGet('term');
        $clientes=$this->clientes->like('nombre',$valor)->where('activo', 1)->findAll();
		
        if (!empty($clientes)){
            
            foreach($clientes as $row ){
                $data['id']=$row['id'];
                $data['value']=$row['nombre'];
                
                array_push($returnData,$data);
            }
        }
        
        echo json_encode($returnData);
		
	}
	
	
	
}






?>