<?php 

namespace App\Controllers;
use App\Models\VentasModels;
use App\Models\TemporalCompraModel;
use App\Models\DetallesVentaModels;
use App\Models\ProductosModels;
use App\Models\configuracionesModels;
use App\Models\cajasModels;
use App\Models\detalle_roles_permisosModels;


class Ventas extends BaseController{
	
	protected $ventas,$temporal_ventas,$detalle_venta,$productos,$configuraciones,$cajas;
	protected $reglas,$session,$detalleRolesPermisos;
	
	
	public function __construct(){
		
		$this->ventas=new VentasModels();
		$this->detalle_venta=new DetallesVentaModels();
        $this->configuraciones=new configuracionesModels();
        $this->productos=new productosModels();
        $this->cajas=new cajasModels();
        $this->session=session();
        $this->detalleRolesPermisos=new detalle_roles_permisosModels();
        
		
		
		helper(['form']);
		
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function index(){
        if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        
        $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'MenuCaja');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/inicio');
           
           
            
        }
        
        $datos=$this->ventas->obtener(1);
		$data=['titulo'=>'Ventas','datos'=>$datos];
		
		
        echo view('header');
		echo view('ventas/ventas', $data);
		echo view('footer');
		
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
    
    public function eliminados(){
        if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        
        $datos=$this->ventas->obtener(0);
		$data=['titulo'=>'Ventas','datos'=>$datos];
		
		
        echo view('header');
		echo view('ventas/eliminados', $data);
		echo view('footer');
		
	}
    
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function venta(){
        if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		$permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'MenuVentas');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/inicio');
           
           
            
        }
		
		$data=['titulo'=>'Nueva compra'];
		
		
        echo view('header');
		echo view('ventas/venta', $data);
		echo view('footer');
		
	}
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function agregar(){
		if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		
		$data=['titulo'=>'Agregar compra'];
		
		
        echo view('header');
		echo view('compras/agregar', $data);
		echo view('footer');
		
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function guarda(){
        if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		
		$id_venta=$this->request->getPost('id_venta');
		$total=preg_replace('/[\$,]/', '', $this->request->getPost('total'));
        $forma_pago=$this->request->getPost('forma_pago');
        $id_cliente=$this->request->getPost('id_cliente');
        
        
        
        
      
        
		$session= session();
       
		$caja=$this->cajas->where('id', $session->id_caja)->first();
        $folio=$caja['folio'];
      
		
        
        
       $resultadoID=$this->ventas->insertaVenta($folio,$total,$session->id_id,$session->id_caja,$id_cliente,$forma_pago);
        
                                              
		
		
        
        
        
        
        
		$this->temporal_compras=new TemporalCompraModel();
		
		if($resultadoID){
            
            $folio++;
			$this->cajas->update($session->id_caja,['folio'=>$folio]);
			
			$resultadoCompra=$this->temporal_compras->porCompra($id_venta);
			
			foreach($resultadoCompra as $row){
				
				
				$this->detalle_venta->save([
					'id_venta'=>$resultadoID,
					'id_producto'=>$row['id_producto'],
					'nombre'=>$row['nombre'],
					'cantidad'=>$row['cantidad'],
					'precio'=>$row['precio'],
                   
					
				]);
                
                $this->productos=new productosModels();
                $this->productos->actualizaStock($row['id_producto'],$row['cantidad'],'-');
                
                
			}
            $this->temporal_compras->eliminarCompra($id_venta);
		}
		return redirect()->to(base_url()."/ventas/muestraTicket/".$resultadoID);
			
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
    function muestraTicket($id_venta){
        if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        $data['id_venta']=$id_venta;
        echo view ('header');
        echo view ('ventas/ver_ticket',$data);
        echo view ('footer');
        
        
    }
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
     function generaTicket($id_venta){
         if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        
         $datosVenta=$this->ventas->where('id', $id_venta)->first();
         $detalleVenta=$this->detalle_venta->select('*')->where('id_venta', $id_venta)->findAll();
         
          $nombreTienda=$this->configuraciones->select('valor')->where('nombre', 'n_nombre_ticket')->get()->getRow()->valor;
          $direccionTienda=$this->configuraciones->select('valor')->where('nombre', 'n_direccion')->get()->getRow()->valor;
         
         
                 $pdf =new \FPDF('P','mm',array(80,200));
                 $pdf->AddPage();
         $pdf->SetMargins(5,5,5);
         $pdf->SetTitle("Venta");
         $pdf->SetFont('Arial','B',14);
          
          $pdf->SetFont('Arial','B',12);
         
         
         $pdf->Image(base_url().'/dist/img/logo/CENTRO-PIEL.png',5,5,20,20, 'PNG');
         
            
           $pdf->Cell(0,5,$nombreTienda,0,1,'C');
          $pdf->Ln();
         $pdf->Ln();
         $pdf->SetFont('Arial','',9);
         $pdf->Cell(0,4,utf8_decode('Dermatología Clínica Quirírgica y Estética'),0,1,'C');
         $pdf->Cell(0,4,utf8_decode('Diana Elizabeth Piñón González'),0,1,'C');
         $pdf->Cell(0,4,utf8_decode('RFC PIGD850813GV6'),0,1,'C');
         $pdf->Cell(0,4,utf8_decode('Av Valdepeñas 2382A Lomas de Zapopan'),0,1,'C');
         
         $pdf->Cell(0,4,utf8_decode('Tel 3323035054   Cel 3325074547'),0,1,'C');
         
          $pdf->Cell(0,4,utf8_decode('Fecha y Hora: '.$datosVenta['fecha_alta']),0,1,'C');
          $pdf->Cell(0,4,utf8_decode('Folio: '.$datosVenta['folio']),0,1,'C');
         
         
         
         
         
         
         
         
         
        
          $pdf->Ln();
         
          $pdf->SetFont('Arial','B',8);
 
$pdf->Cell(0,2,'=========================================',0,0, 'L');
         $pdf->Ln();
         
         $pdf->Cell(9,5,'Cant.',0,0, 'L');
         $pdf->Cell(36,5,utf8_decode('Nombre'),0,0, 'L');
          $pdf->Cell(13,5,'Precio',0,0, 'L');
         $pdf->Cell(18,5,'Importe',0,1, 'L');
         
         $pdf->Cell(0,2,'------------------------------------------------------------------------',0,0, 'L');
         $pdf->Ln();
         
         
         $pdf->SetFont('Arial','',8);
         
        
        
         
          $pdf->SetFont('Arial','',8);
        $contador=1;
         
         

         foreach( $detalleVenta as $row){
             
            $pdf->Cell(5,5,$contador,0,0, 'L');
         $pdf->Cell(42,5,$row['nombre'],0,0, 'L');
          $pdf->Cell(6,5,$row['precio'],0,0, 'L');
          $importe=number_format($row['precio']*$row['cantidad'],2,'.',',');
         $pdf->Cell(18,5,'$'.$importe,0,0, 'R');
              $pdf->Ln();
         
             $contador++;
         }
         
             $pdf->Ln();
         
          $pdf->SetFont('Arial','B',10);
         
        $pdf->Cell(0,5,'Total $'.number_format($datosVenta['total'],2,'.','.'),0,1,'R');
              
             
         $pdf->Ln();$pdf->Ln();
         $pdf->Cell(0,5,utf8_decode('Gracias por su compra ! :-)'),0,0, 'C');
                 $this->response->setHeader('Content-Type', 'application/pdf');
                     $pdf->Output("compra_pdf.pdf", "I");
         
      
         
         
         
         
        
    }
    
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
    public function eliminar($id){
        if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        
        $productos=$this->detalle_venta->where('id_venta',$id)->findAll();
        
        foreach ($productos as $producto){
            $this->productos->actualizaStock($producto['id_producto'],$producto['cantidad'],'+');
        }
        $this->ventas->update($id,['activo' =>0]);
        return redirect()->to(base_url().'/ventas');
    }
    
    
//--------------------------------------------------------------------------------------------------------------------------------------------------------------	
public function reingresar($id){
            
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		
		
		$this->ventas->update($id,['activo'=> 1]);
		return redirect()->to(base_url().'/ventas');
		
		
        
		
	}    

}






?>