<?php 

namespace App\Controllers;
use App\Models\ProductosModels;
use App\Models\unidadesModels;
use App\Models\categoriasModels;
use App\Models\detalle_roles_permisosModels;

class Productos extends BaseController{
	
	protected $productos;
	protected $reglas;
	protected $reglas2,$session,$detalleRolesPermisos;
	
	public function __construct(){
		
		$this->productos=new ProductosModels();
		$this->unidades=new UnidadesModels();
		$this->categorias=new CategoriasModels();
        $this->detalleRolesPermisos=new detalle_roles_permisosModels();
        $this->session=session();
		helper(['form']);
		$this->reglas=[
			'codigo'=>[
					   'rules'=>'required|is_unique[productos.codigo]',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.',
						   'is_unique'=>'Los valores del campo {field} no deben repetirse.'
					   ]
			],
			
			'nombre'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.'
					   ]
				],
			'id_unidad'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo UNIDAD es obligatorio.'
					   ]
				],
			'id_categoria'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo CATEGORIA es obligatorio.'
					   ]
				],
			'precio_venta'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo PRECIO VENTA es obligatorio.'
					   ]
				],
			'precio_compra'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo PRECIO COMPRA es obligatorio.'
					   ]
				],
			'stock_minimo'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo STOCK MÍNIMO es obligatorio.'
					   ]
				],
			'inventariable'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo INVENTARIABLE es obligatorio.'
					   ]
				]
			
			
			
			];
		
		
		
		
		
		
		$this->reglas2=[
		
			'codigo2'=>[
					  'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.'
						   
					   ]
			],
			'nombre'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.'
					   ]
				],
			'id_unidad'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo UNIDAD es obligatorio.'
					   ]
				],
			'id_categoria'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo CATEGORIA es obligatorio.'
					   ]
				],
			'precio_venta'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo PRECIO VENTA es obligatorio.'
					   ]
				],
			'precio_compra'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo PRECIO COMPRA es obligatorio.'
					   ]
				],
			'stock_minimo'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo STOCK MÍNIMO es obligatorio.'
					   ]
				],
			'inventariable'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo INVENTARIABLE es obligatorio.'
					   ]
				]
			
			
			
			];
	}
	
	
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------	
public function index($activo=1){
        
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        
        
        $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'ProductosCatalogo');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/inicio');
           
           
            
        }

        
		$productos=$this->productos->where('activo',$activo)->findAll();
		$data=['titulo'=>'Productos','datos'=>$productos];
		
		
        echo view('header');
		echo view('productos/productos', $data);
		echo view('footer');
		
	}
	
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------	
public function agregar(){
        
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        
        
         $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'ProductosAgregar');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/productos');
           
           
            
        }
        
        
		$unidades = $this->unidades->where('activo',1)->findAll();
		$categorias=$this->categorias->where('activo',1)->findAll();
		
		$data=['titulo'=>'Agregar producto','unidades'=>$unidades, 'categorias'=>$categorias];
		
		
        echo view('header');
		echo view('productos/agregar', $data);
		echo view('footer');
		
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function insertar(){
        
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		
			if($this->request->getMethod()=="post" && $this->validate($this->reglas)){
		
		
			
			$this->productos->save(['codigo'=> $this->request->getPost('codigo'),
									'nombre'=>$this->request->getPost('nombre'),
									'id_unidad'=>$this->request->getPost('id_unidad'),
									'id_categoria'=>$this->request->getPost('id_categoria'),
									'precio_venta'=>$this->request->getPost('precio_venta'),
									'precio_compra'=>$this->request->getPost('precio_compra'),
									'stock_minimo'=>$this->request->getPost('stock_minimo'),
									'inventariable'=>$this->request->getPost('inventariable')]);
			
		return redirect()->to(base_url().'/productos');
			
		}
		
		else {
			
		
		
			$unidades = $this->unidades->where('activo',1)->findAll();
		$categorias=$this->categorias->where('activo',1)->findAll();
		
		$data=['titulo'=>'Agregar producto','unidades'=>$unidades, 'categorias'=>$categorias, 'validation'=> $this->validator];
			
        echo view('header');
		echo view('productos/agregar', $data);
		echo view('footer');
			
		}
		
        
		
	}
	
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function editar($id, $valid=null){
        
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        
        
        $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'ProductosEditar');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/productos');
           
           
            
        }
        
        
		
			$unidades = $this->unidades->where('activo',1)->findAll();
		$categorias=$this->categorias->where('activo',1)->findAll();
		$productos=$this->productos->where('id',$id)->first();
		
		if($valid != null){
		$data=['titulo'=>'Editar producto','unidades'=>$unidades, 'categorias'=>$categorias,'productos'=>$productos,'validation'=> $valid ];
		
		}else{
		$data=['titulo'=>'Editar producto','unidades'=>$unidades, 'categorias'=>$categorias,'productos'=>$productos ];	
			
		}
        echo view('header');
		echo view('productos/editar', $data);
		echo view('footer');
		
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------	
public function actualizar(){
        
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		if($this->request->getMethod()=="post" && $this->validate($this->reglas2)){
				
		$this->productos->update($this->request->getPost('id'),['codigo'=> $this->request->getPost('codigo2'),
									'nombre'=>$this->request->getPost('nombre'),
									'id_unidad'=>$this->request->getPost('id_unidad'),
									'id_categoria'=>$this->request->getPost('id_categoria'),
									'precio_venta'=>$this->request->getPost('precio_venta'),
									'precio_compra'=>$this->request->getPost('precio_compra'),
									'stock_minimo'=>$this->request->getPost('stock_minimo'),
									'inventariable'=>$this->request->getPost('inventariable')]);
		
		
		
		
		return redirect()->to(base_url().'/productos');
		}else{
			
			return $this->editar($this->request->getPost('id'),$this->validator);
		}
		
        
		
	}
	
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------	
public function eliminar($id){
        
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		
        
        $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'ProductosEliminar');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/productos');
           
           
            
        }
        
		
		$this->productos->update($id,['activo'=> 0]);
		return redirect()->to(base_url().'/productos');
		
		
        
		
	}
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------	
public function eliminados($activo=0){
        
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        
        
        
        $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'ProductosEliminados');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/productos');
           
           
            
        }
        
        
        
        
		$productos=$this->productos->where('activo',$activo)->findAll();
		$data=['titulo'=>'Productos eliminadas','datos'=>$productos];
		
		
        echo view('header');
		echo view('productos/eliminadas', $data);
		echo view('footer');
		
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------	
public function reingresar($id){
            
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		
		
		$this->productos->update($id,['activo'=> 1]);
		return redirect()->to(base_url().'/productos');
		
		
        
		
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------	
public function buscarPorCodigo($codigo){
        
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		
		$this->productos->select('*');
		$this->productos->where('codigo', $codigo);
		$this->productos->where('activo', 1);
		$datos=$this->productos->get()->getRow();
		
		
		$res['existe']=false;
		$res['datos']='';
		$res['error']='';
		
		if($datos){
			$res['datos']=$datos;
			$res['existe']=true;
			
		}else{
			
			$res['error']='No existe el producto';
			$res['existe']=false;
			
		}
		
		echo json_encode($res);
		
		
        
		
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------    
public function autocompleteData(){
         
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		$returnData=array();
		
		$valor=$this->request->getGet('term');
        $productos=$this->productos->like('codigo',$valor)->where('activo', 1)->findAll();
		
        if (!empty($productos)){
            
            foreach($productos as $row ){
                $data['id']=$row['id'];
                $data['value']=$row['codigo'];
                $data['label']=$row['codigo'].'-'.$row['nombre'];
                
                array_push($returnData,$data);
            }
        }
        
        echo json_encode($returnData);
		
	}
	
	
    
    
//--------------------------------------------------------------------------------------------------------------------------------------------------------------    
function muestraCodigo(){
        
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        
        echo view ('header');
        echo view ('productos/ver_codigo');
        echo view ('footer');
        
        
    }
	
    
//--------------------------------------------------------------------------------------------------------------------------------------------------------------    
public function generaBArras(){
        
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        
        
        
        
        
         $pdf =new \FPDF('L','mm','Letter');
         $pdf->AddPage();
         $pdf->SetMargins(10,10,10);
         $pdf->SetTitle("Codigos de barras");
         
        $productos=$this->productos->where('activo',1)->findAll();
        
        foreach($productos as $producto){
            
            $codigo=$producto['codigo'];
            
              $generaBarcode= new \Barcode_genera();
        $generaBarcode->barcode("dist/img/barcode/".$codigo.".png", $codigo, 20, "horizontal", "code39", true);
        
            $pdf->Image("dist/img/barcode/".$codigo.".png");
            unlink("dist/img/barcode/".$codigo.".png");
            
        }
        
     
        
        
         $this->response->setHeader('Content-Type', 'application/pdf');
                     $pdf->Output("Codigo.pdf", "I");
      
        
        
    }
    
    
//--------------------------------------------------------------------------------------------------------------------------------------------------------------    
function muestraMinimos(){
         
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
    
    
        $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'SubReportesMin');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/inicio');
           
           
            
        }
        
    
        
        echo view ('header');
        echo view ('productos/ver_minimos');
        echo view ('footer');
        
        
    }
	
    
//--------------------------------------------------------------------------------------------------------------------------------------------------------------    
public function generaMinimosPdf(){
        
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        
         $pdf =new \FPDF('L','mm','Letter');
         $pdf->AddPage();
         $pdf->SetMargins(10,10,10);
         $pdf->SetTitle("Productos con stock minimo");
       
        
        
        
        
        
        
        
    
         $pdf->SetFont('Arial','B',14);
          $pdf->Cell(0,5,'Productos con stock minimo',0,1,'C');
          $pdf->SetFont('Arial','B',12);
         
         
         $pdf->Image(base_url().'/dist/img/logo/CENTRO-PIEL.png',230,0,40,40, 'PNG');
        $pdf->Ln();$pdf->Ln();$pdf->Ln();$pdf->Ln();
       
        $pdf->SetFont('Arial','B',10);
         $pdf->SetFillColor(0,0,0,0);
         $pdf->SetTextColor(255,255,255);
         $pdf->Cell(0,5,'Detalle de productos',1,1, 'C', 1);
         $pdf->SetTextColor(0,0,0);
         $pdf->Cell(14,5,'No',1,0, 'L');
         $pdf->Cell(40,5,utf8_decode('Código'),1,0, 'L');
          $pdf->Cell(145.5,5,'Nombre',1,0, 'L');
          $pdf->Cell(30,5,'Existencia',1,0, 'L');
          $pdf->Cell(30,5,'Stock minimo',1,0, 'L');
        
         $pdf->SetFont('Arial','',8);
    $datosProductos=$this->productos->getProductosMinimo();
        
        $pdf->SetTextColor(0,0,0);
         $contador=1;
        $pdf->Ln();
        foreach($datosProductos as $producto){
            
           
         $pdf->Cell(14,5,$contador,1,0, 'L');
         $pdf->Cell(40,5,$producto['codigo'],1,0, 'L');
          $pdf->Cell(145.5,5,$producto['nombre'],1,0, 'L');
          $pdf->Cell(30,5,$producto['existencias'],1,0, 'L');
          $pdf->Cell(30,5,$producto['stock_minimo'],1,0, 'L');
            $pdf->Ln();
             $contador++;
             
        }
            
        
        
        
        
         $this->response->setHeader('Content-Type', 'application/pdf');
                     $pdf->Output("stock minimo.pdf", "I");
      
        
        
    }
	
	
	
    
    
    
    
    
	
}






?>